/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;
import org.apache.mailet.base.GenericMailet;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxService;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.module.DefaultTxDetailParserModule;
import org.nhindirect.common.tx.module.ProviderTxServiceModule;
import org.nhindirect.common.tx.provider.NoOpTxServiceClientProvider;
import org.nhindirect.common.tx.provider.RESTTxServiceClientProvider;
import org.nhindirect.gateway.GatewayConfiguration;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.module.DSNCreatorProviderModule;
import org.nhindirect.stagent.AddressSource;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;

public abstract class AbstractNotificationAwareMailet
extends GenericMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(AbstractNotificationAwareMailet.class);
    protected DSNCreator dsnCreator;
    protected TxDetailParser txParser;
    protected TxService txService;

    public void init() throws MessagingException {
        super.init();
        Collection<Module> modules = this.getInitModules();
        this.createTxServices(modules);
        this.createDSNGenerator(modules);
    }

    protected Collection<Module> getInitModules() {
        return null;
    }

    protected void createDSNGenerator(Collection<Module> initModules) {
        boolean usingDefaultMoudles;
        Collection<Module> modules = initModules;
        boolean bl = usingDefaultMoudles = modules == null;
        if (modules == null) {
            Provider<DSNCreator> provider = this.getDSNProvider();
            if (provider == null) {
                return;
            }
            DSNCreatorProviderModule module = DSNCreatorProviderModule.create(provider);
            modules = Arrays.asList(new Module[]{module});
        }
        Injector dsnInjector = Guice.createInjector(modules);
        try {
            this.dsnCreator = (DSNCreator)dsnInjector.getInstance(DSNCreator.class);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"First attempt to create DSNCreator failed.", (Throwable)e);
            if (!usingDefaultMoudles) {
                LOGGER.debug((Object)"Will attempt to create from default DSNCreator from Guice module.");
            }
            LOGGER.warn((Object)"DSNCreator already attempted to use the defualt DSNCreator Guice module.  DSN creation will be disabled.");
        }
        if (this.dsnCreator == null && !usingDefaultMoudles) {
            try {
                Provider<DSNCreator> provider = this.getDSNProvider();
                if (provider == null) {
                    return;
                }
                DSNCreatorProviderModule module = DSNCreatorProviderModule.create(provider);
                modules = Arrays.asList(new Module[]{module});
                dsnInjector = Guice.createInjector(modules);
                this.dsnCreator = (DSNCreator)dsnInjector.getInstance(DSNCreator.class);
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to create DSNCreator.  DSN creation will be disabled.");
            }
        }
    }

    protected abstract Provider<DSNCreator> getDSNProvider();

    protected void sendDSN(Tx tx, NHINDAddressCollection undeliveredRecipeints) {
        this.sendDSN(tx, undeliveredRecipeints, true);
    }

    protected void sendDSN(Tx tx, NHINDAddressCollection undeliveredRecipeints, boolean useSenderAsPostmaster) {
        try {
            Collection<MimeMessage> msgs;
            if (this.dsnCreator != null && (msgs = this.dsnCreator.createDSNFailure(tx, undeliveredRecipeints, useSenderAsPostmaster)) != null && msgs.size() > 0) {
                for (MimeMessage msg : msgs) {
                    this.getMailetContext().sendMail(msg);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Error sending DSN failure message.", e);
        }
    }

    protected Tx getTxToTrack(MimeMessage msg, NHINDAddress sender, NHINDAddressCollection recipients) {
        if (this.txParser == null) {
            return null;
        }
        try {
            Map details = this.txParser.getMessageDetails(msg);
            if (sender != null) {
                details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, sender.getAddress().toLowerCase(Locale.getDefault())));
            }
            if (recipients != null && !recipients.isEmpty()) {
                details.put(TxDetailType.RECIPIENTS.getType(), new TxDetail(TxDetailType.RECIPIENTS, recipients.toString().toLowerCase(Locale.getDefault())));
            }
            return new Tx(TxUtil.getMessageType((MimeMessage)msg), details);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to parse message to Tx object.", (Throwable)e);
            return null;
        }
    }

    protected void createTxServices(Collection<Module> initModules) {
        boolean usingDefaultTxServiceMoudles;
        Collection<Module> modules = initModules;
        boolean bl = usingDefaultTxServiceMoudles = modules == null;
        if (modules == null) {
            modules = this.createDefaultTxServiceModules();
        }
        Injector txInjector = Guice.createInjector(modules);
        try {
            this.txParser = (TxDetailParser)txInjector.getInstance(TxDetailParser.class);
            this.txService = (TxService)txInjector.getInstance(TxService.class);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"First attempt to create message monitoring service failed.", (Throwable)e);
            if (!usingDefaultTxServiceMoudles) {
                LOGGER.debug((Object)"Will attempt to create from default Tx service Guice module.");
            }
            LOGGER.warn((Object)"Monitoring service already attempted to use the defualt Tx service Guice module.  Monitoring will be disabled.");
        }
        if (!(this.txParser != null && this.txService != null || usingDefaultTxServiceMoudles)) {
            try {
                modules = this.createDefaultTxServiceModules();
                txInjector = Guice.createInjector(modules);
                if (this.txParser == null) {
                    this.txParser = (TxDetailParser)txInjector.getInstance(TxDetailParser.class);
                }
                if (this.txService == null) {
                    this.txService = (TxService)txInjector.getInstance(TxService.class);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to create message monitoring service.  Monitoring will be disabled");
            }
        }
    }

    protected Collection<Module> createDefaultTxServiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)DefaultTxDetailParserModule.create());
        String monitoringURLParam = GatewayConfiguration.getConfigurationParam("MessageMonitoringServiceURL", (Mailet)this, "");
        if (!monitoringURLParam.isEmpty()) {
            modules.add((Module)ProviderTxServiceModule.create((Provider)new RESTTxServiceClientProvider(monitoringURLParam)));
        } else {
            LOGGER.info((Object)"MessageMonitoringServiceURL is null or empty.  Will fall back to the the NoOp message monitor.");
            modules.add((Module)ProviderTxServiceModule.create((Provider)new NoOpTxServiceClientProvider()));
        }
        return modules;
    }

    protected NHINDAddressCollection getMailRecipients(Mail mail) throws MessagingException {
        NHINDAddressCollection recipients = new NHINDAddressCollection();
        Collection recips = mail.getRecipients();
        if (recips == null || recips.size() == 0) {
            Address[] recipsAddr;
            for (Address addr : recipsAddr = mail.getMessage().getAllRecipients()) {
                recipients.add((Object)new NHINDAddress(addr.toString(), (AddressSource)null));
            }
        } else {
            for (MailAddress addr : recips) {
                recipients.add((Object)new NHINDAddress(addr.toString(), (AddressSource)null));
            }
        }
        return recipients;
    }

    protected NHINDAddress getMailSender(Mail mail) throws MessagingException {
        InternetAddress senderAddr = AbstractNotificationAwareMailet.getSender(mail);
        if (senderAddr == null) {
            throw new MessagingException("Failed to process message.  The sender cannot be null or empty.");
        }
        return new NHINDAddress(senderAddr, AddressSource.From);
    }

    public static InternetAddress getSender(Mail mail) {
        InternetAddress retVal = null;
        if (mail.getSender() != null) {
            retVal = mail.getSender().toInternetAddress();
        } else {
            Address[] senderAddr = null;
            try {
                if (mail.getMessage() == null) {
                    return null;
                }
                senderAddr = mail.getMessage().getFrom();
                if (senderAddr == null || senderAddr.length == 0) {
                    return null;
                }
            }
            catch (MessagingException e) {
                return null;
            }
            retVal = (InternetAddress)senderAddr[0];
        }
        return retVal;
    }
}

