/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Provider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ReliableDispatchedNotificationProducer;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.provider.FailedDeliveryDSNCreatorProvider;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;

public class TimelyAndReliableLocalDelivery
extends AbstractNotificationAwareMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TimelyAndReliableLocalDelivery.class);
    protected static final String RELIABLE_DELIVERY_OPTION = "X-DIRECT-FINAL-DESTINATION-DELIVERY=optional,true";
    @Resource(name="recipientrewritetable")
    private Object rrt;
    @Resource(name="usersrepository")
    private Object usersRepository;
    @Resource(name="mailboxmanager")
    private Object mailboxManager;
    @Resource(name="domainlist")
    private Object domainList;
    @Resource(name="filesystem")
    private Object fileSystem;
    protected Object localDeliveryMailet;
    protected Method serviceMethod;
    protected NotificationProducer notificationProducer;

    @Override
    public void init() throws MessagingException {
        super.init();
        try {
            this.localDeliveryMailet = this.createLocalDeliveryClass();
            Method initMethod = Mailet.class.getDeclaredMethod("init", MailetConfig.class);
            this.serviceMethod = Mailet.class.getDeclaredMethod("service", Mail.class);
            Class<?> localDeliveryMailetClass = this.localDeliveryMailet.getClass();
            Field field = this.getDeclaredFieldQuietly(localDeliveryMailetClass, "rrt");
            if (field != null) {
                field.setAccessible(true);
                field.set(this.localDeliveryMailet, this.rrt);
            }
            if ((field = this.getDeclaredFieldQuietly(localDeliveryMailetClass, "usersRepository")) != null) {
                field.setAccessible(true);
                field.set(this.localDeliveryMailet, this.usersRepository);
            }
            if ((field = this.getDeclaredFieldQuietly(localDeliveryMailetClass, "mailboxManager")) != null) {
                field.setAccessible(true);
                field.set(this.localDeliveryMailet, this.mailboxManager);
            }
            if ((field = this.getDeclaredFieldQuietly(localDeliveryMailetClass, "domainList")) != null) {
                field.setAccessible(true);
                field.set(this.localDeliveryMailet, this.domainList);
            }
            if ((field = this.getDeclaredFieldQuietly(localDeliveryMailetClass, "fileSystem")) != null) {
                field.setAccessible(true);
                field.set(this.localDeliveryMailet, this.fileSystem);
            }
            initMethod.invoke(this.localDeliveryMailet, this.getMailetConfig());
        }
        catch (Exception e) {
            throw new MessagingException("Failed to initialize TimelyAndReliableLocalDelivery.", e);
        }
        this.notificationProducer = new ReliableDispatchedNotificationProducer(new NotificationSettings(true, "Local Direct Delivery Agent", "Your message was successfully dispatched."));
    }

    protected Field getDeclaredFieldQuietly(Class<?> clazz, String fieldName) {
        Field retVal = null;
        try {
            retVal = clazz.getDeclaredField(fieldName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return retVal;
    }

    protected Object createLocalDeliveryClass() throws Exception {
        Class<?> clazz = TimelyAndReliableLocalDelivery.class.getClassLoader().loadClass("org.apache.james.transport.mailets.LocalDelivery");
        return clazz.newInstance();
    }

    public void service(Mail mail) throws MessagingException {
        LOGGER.debug((Object)"Calling timely and reliable service method.");
        boolean deliverySuccessful = false;
        MimeMessage msg = mail.getMessage();
        boolean isReliableAndTimely = TxUtil.isReliableAndTimelyRequested((MimeMessage)msg);
        NHINDAddressCollection recipients = this.getMailRecipients(mail);
        NHINDAddress sender = this.getMailSender(mail);
        try {
            this.serviceMethod.invoke(this.localDeliveryMailet, mail);
            deliverySuccessful = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to invoke service method.", (Throwable)e);
        }
        Tx txToTrack = this.getTxToTrack(msg, sender, recipients);
        if (deliverySuccessful) {
            Collection<NotificationMessage> notifications;
            if (isReliableAndTimely && txToTrack.getMsgType() == TxMessageType.IMF && (notifications = this.notificationProducer.produce(new Message(msg), recipients.toInternetAddressCollection())) != null && notifications.size() > 0) {
                LOGGER.debug((Object)"Sending MDN \"dispatched\" messages");
                for (NotificationMessage message : notifications) {
                    try {
                        message.setHeader("Disposition-Notification-Options", RELIABLE_DELIVERY_OPTION);
                        message.saveChanges();
                        this.getMailetContext().sendMail((MimeMessage)message);
                    }
                    catch (Throwable t) {
                        LOGGER.error((Object)"Error sending MDN dispatched message.", t);
                    }
                }
            }
        } else if (txToTrack != null && txToTrack.getMsgType() == TxMessageType.IMF) {
            this.sendDSN(txToTrack, recipients, false);
        }
        LOGGER.debug((Object)"Exiting timely and reliable service method.");
    }

    @Override
    protected Provider<DSNCreator> getDSNProvider() {
        return new FailedDeliveryDSNCreatorProvider((Mailet)this);
    }
}

