/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.config;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Setting;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.config.DNSServerConfig;
import org.nhindirect.dns.module.DNSServerModule;
import org.nhindirect.dns.provider.BasicDNSServerSettingsProvider;
import org.nhindirect.dns.provider.ConfigServiceDNSStoreProvider;

public class WSDNSServerConfig
implements DNSServerConfig {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(WSDNSServerConfig.class);
    private static final String DNS_SERVER_BINDING = "DNSServerBindings";
    private static final String DNS_SERVER_PORT = "DNSServerPort";
    private Provider<DNSStore> storeProvider;
    private Provider<DNSServerSettings> settings;
    private final ConfigurationServiceProxy cfService;
    private final URL configServiceLocation;

    public WSDNSServerConfig(URL configServiceLocation, Provider<DNSStore> storeProvider, Provider<DNSServerSettings> settings) {
        this.storeProvider = storeProvider;
        this.configServiceLocation = configServiceLocation;
        this.settings = settings;
        this.cfService = new ConfigurationServiceProxy(configServiceLocation.toExternalForm());
    }

    @Override
    public Injector getServerInjector() {
        LOGGER.info((Object)("Looking up DNS server configuration info from location " + this.configServiceLocation.toExternalForm()));
        Provider<DNSServerSettings> settingsProv = this.getServerSettings();
        if (this.storeProvider == null) {
            this.storeProvider = new ConfigServiceDNSStoreProvider(this.configServiceLocation);
        }
        DNSServerModule module = DNSServerModule.create(this.storeProvider, settingsProv);
        return Guice.createInjector((Module[])new Module[]{module});
    }

    private Provider<DNSServerSettings> getServerSettings() {
        String ipBindings = "";
        int port = 0;
        try {
            Setting[] settings = this.cfService.getSettingsByNames(new String[]{DNS_SERVER_BINDING, DNS_SERVER_PORT});
            if (settings != null && settings.length > 0) {
                for (Setting setting : settings) {
                    if (setting.getName().equalsIgnoreCase(DNS_SERVER_BINDING)) {
                        ipBindings = setting.getValue();
                        continue;
                    }
                    if (!setting.getName().equalsIgnoreCase(DNS_SERVER_PORT)) continue;
                    String sPort = setting.getValue();
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("Could not parse port setting " + port + " from configuration service"));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not get DNS setting from web service.");
        }
        if ((ipBindings == null || ipBindings.length() == 0) && port == 0 && this.settings != null) {
            LOGGER.info((Object)"Using DNS server settings from injected provider.");
            return this.settings;
        }
        LOGGER.info((Object)"Using DNS server settings from configuration service.");
        return new BasicDNSServerSettingsProvider(ipBindings, port);
    }
}

