/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.mail;

import java.io.InputStream;
import java.lang.reflect.Method;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDNStandard {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(MDNStandard.class);
    private static Class<?> dsnClass;
    private static Method getHeaders;
    public static final String Action_Manual = "manual-action";
    public static final String Action_Automatic = "automatic-action";
    public static final String Send_Manual = "MDN-sent-manually";
    public static final String Send_Automatic = "MDN-sent-automatically";
    public static final String Disposition_Displayed = "displayed";
    public static final String Disposition_Processed = "processed";
    public static final String Disposition_Dispatched = "dispatched";
    public static final String Disposition_Deleted = "deleted";
    public static final String Disposition_Denied = "denied";
    public static final String Disposition_Error = "error";
    public static final String Modifier_Error = "error";
    public static final String ReportType = "report-type";
    public static final String ReportTypeValueNotification = "disposition-notification";
    public static final String DispositionOption_TimelyAndReliable = "X-DIRECT-FINAL-DESTINATION-DELIVERY";

    public static String getMDNField(MimeMessage msg, String field) {
        String fieldValue;
        InternetHeaders headers = null;
        try {
            headers = MDNStandard.getNotificationFieldsAsHeaders(msg);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)"Failed to retrieve MDN field from message.  Message may not be an MDN message.", (Throwable)e);
        }
        if (headers != null && (fieldValue = headers.getHeader(field, ",")) != null) {
            return fieldValue;
        }
        return "";
    }

    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message can not be null");
        }
        MimeMultipart mm = null;
        try {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(message.getRawInputStream(), message.getContentType());
            mm = new MimeMultipart((DataSource)dataSource);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse notification fields.", e);
        }
        return MDNStandard.getNotificationFieldsAsHeaders(mm);
    }

    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMultipart mm) {
        InternetHeaders retVal = null;
        if (mm == null) {
            throw new IllegalArgumentException("Multipart can not be null");
        }
        try {
            String[] fields;
            if (mm.getCount() < 2) {
                throw new IllegalArgumentException("Multipart can not be null");
            }
            BodyPart part = mm.getBodyPart(1);
            try {
                Object contecntObj = part.getContent();
                if (dsnClass != null && dsnClass.getCanonicalName().equals(contecntObj.getClass().getCanonicalName())) {
                    retVal = (InternetHeaders)getHeaders.invoke(contecntObj, new Object[0]);
                    return retVal;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!part.getContentType().equalsIgnoreCase("message/disposition-notification")) {
                throw new IllegalArgumentException("Notification part content type is not message/disposition-notification");
            }
            retVal = new InternetHeaders();
            for (String field : fields = MDNStandard.getPartContentBodyAsString(part).split("\r\n")) {
                int idx = field.indexOf(":");
                if (idx <= -1) continue;
                String name = field.substring(0, idx);
                String value = field.substring(idx + 1).trim();
                retVal.setHeader(name, value);
            }
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Failed to parse notification fields.", e);
        }
        return retVal;
    }

    protected static String getPartContentBodyAsString(BodyPart part) {
        try {
            Object content = part.getContent();
            if (content instanceof String) {
                return content.toString();
            }
            if (content instanceof InputStream) {
                InputStream str = (InputStream)part.getContent();
                byte[] bytes = new byte[str.available()];
                str.read(bytes);
                return new String(bytes);
            }
            return content.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to handle get notification body as a string.", e);
        }
    }

    static {
        try {
            dsnClass = MDNStandard.class.getClassLoader().loadClass("com.sun.mail.dsn.DispositionNotification");
            getHeaders = dsnClass.getMethod("getNotifications", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Headers {
        public static final String Disposition = "Disposition";
        public static final String DispositionNotificationTo = "Disposition-Notification-To";
        public static final String DispositionNotificationOptions = "Disposition-Notification-Options";
        public static final String ReportingAgent = "Reporting-UA";
        public static final String Gateway = "MDN-Gateway";
        public static final String OriginalMessageID = "Original-Message-ID";
        public static final String FinalRecipient = "Final-Recipient";
        public static final String Failure = "Failure";
        public static final String Error = "Error";
        public static final String Warning = "Warning";
    }

    public static class MediaType {
        public static final String ReportMessage = "multipart/report";
        public static final String DispositionReport = "multipart/report; report-type=disposition-notification";
        public static final String DispositionNotification = "message/disposition-notification";
        public static final String ReportType = "report-type";
        public static final String ReportTypeValueNotification = "disposition-notification";
    }
}

