/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import org.apache.avalon.phoenix.components.application.BlockInvocationHandler;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;

class BlockEntry {
    private static final Class BLOCK_CLASS = BlockEntry.getBlockClass();
    private Object m_object;
    private final ComponentProfile m_componentProfile;
    private BlockInvocationHandler m_invocationHandler;

    public BlockEntry(ComponentProfile componentProfile) {
        this.invalidate();
        this.m_componentProfile = componentProfile;
    }

    public String getName() {
        return this.getProfile().getMetaData().getName();
    }

    public ComponentProfile getProfile() {
        return this.m_componentProfile;
    }

    public synchronized Object getObject() {
        return this.m_object;
    }

    public synchronized void setObject(Object object) {
        this.invalidate();
        if (null != object && !this.isDisableProxy()) {
            ComponentInfo blockInfo = this.m_componentProfile.getInfo();
            Class[] interfaces = this.getServiceClasses(object, blockInfo.getServices());
            this.m_invocationHandler = new BlockInvocationHandler(object, interfaces);
        }
        this.m_object = object;
    }

    public synchronized Object getProxy() {
        if (this.isDisableProxy()) {
            return this.m_object;
        }
        if (null != this.m_invocationHandler) {
            return this.m_invocationHandler.getProxy();
        }
        return null;
    }

    private boolean isDisableProxy() {
        Attribute[] attributes = this.getProfile().getMetaData().getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!attribute.getName().equals("phoenix:disable-proxy")) continue;
            return true;
        }
        return false;
    }

    synchronized void invalidate() {
        if (null != this.m_invocationHandler) {
            this.m_invocationHandler.invalidate();
            this.m_invocationHandler = null;
        }
        this.m_object = null;
    }

    private Class[] getServiceClasses(Object block, ServiceDescriptor[] services) {
        Class[] classes = new Class[services.length + 1];
        ClassLoader classLoader = block.getClass().getClassLoader();
        for (int i = 0; i < services.length; ++i) {
            try {
                classes[i] = classLoader.loadClass(services[i].getType());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        classes[services.length] = BLOCK_CLASS;
        return classes;
    }

    private static Class getBlockClass() {
        try {
            return Class.forName("org.apache.avalon.phoenix.Block");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can not find block class");
        }
    }
}

