/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.ApplicationListener;
import org.apache.avalon.phoenix.BlockListener;
import org.apache.avalon.phoenix.components.application.BlockEntry;
import org.apache.avalon.phoenix.components.application.BlockResourceProvider;
import org.apache.avalon.phoenix.components.application.DependencyGraph;
import org.apache.avalon.phoenix.components.application.ExportHelper;
import org.apache.avalon.phoenix.components.application.ListenerSupport;
import org.apache.avalon.phoenix.components.util.ComponentMetaDataConverter;
import org.apache.avalon.phoenix.containerkit.lifecycle.LifecycleException;
import org.apache.avalon.phoenix.containerkit.lifecycle.LifecycleHelper;
import org.apache.avalon.phoenix.containerkit.lifecycle.ResourceProvider;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.interfaces.ApplicationException;
import org.apache.avalon.phoenix.interfaces.ApplicationMBean;
import org.apache.avalon.phoenix.metadata.SarMetaData;

public final class DefaultApplication
extends AbstractLogEnabled
implements Application,
ApplicationMBean,
Initializable,
Startable,
Disposable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$application$DefaultApplication == null ? (class$org$apache$avalon$phoenix$components$application$DefaultApplication = DefaultApplication.class$("org.apache.avalon.phoenix.components.application.DefaultApplication")) : class$org$apache$avalon$phoenix$components$application$DefaultApplication));
    private static final String PHASE_STARTUP = "startup";
    private static final String PHASE_SHUTDOWN = "shutdown";
    private boolean m_running = false;
    private ApplicationContext m_context;
    private final HashMap m_entries = new HashMap();
    private BlockResourceProvider m_blockAccessor;
    private final ListenerSupport m_listenerSupport = new ListenerSupport();
    private final LifecycleHelper m_lifecycleHelper = new LifecycleHelper();
    private final ExportHelper m_exportHelper = new ExportHelper();
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$application$DefaultApplication;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger(this.m_lifecycleHelper);
        this.setupLogger((Object)this.m_exportHelper);
    }

    public void initialize() throws Exception {
        try {
            this.loadBlockListeners();
        }
        catch (Throwable t) {
            this.getLogger().info("exception while loading listeners:" + t.getMessage() + "\n");
            t.printStackTrace();
            throw new ApplicationException(t.getMessage(), t);
        }
    }

    public void start() throws IllegalStateException, ApplicationException {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        try {
            PartitionProfile partition = this.m_context.getPartitionProfile().getPartition("block");
            ComponentProfile[] blocks = partition.getComponents();
            for (int i = 0; i < blocks.length; ++i) {
                String blockName = blocks[i].getMetaData().getName();
                BlockEntry blockEntry = new BlockEntry(blocks[i]);
                this.m_entries.put(blockName, blockEntry);
            }
            this.runPhase(PHASE_STARTUP);
        }
        catch (Throwable t) {
            this.getLogger().info("exception while starting:" + t.getMessage() + "\n");
            t.printStackTrace();
            throw new ApplicationException(t.getMessage(), t);
        }
        this.m_running = true;
    }

    public void restart() throws IllegalStateException, ApplicationException {
        this.stop();
        this.start();
    }

    public void stop() throws IllegalStateException, ApplicationException {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        try {
            this.runPhase(PHASE_SHUTDOWN);
        }
        catch (Throwable t) {
            this.getLogger().info("exception while stopping:" + t.getMessage() + "\n");
            t.printStackTrace();
            throw new ApplicationException(t.getMessage(), t);
        }
        this.m_running = false;
    }

    public void dispose() {
        this.m_entries.clear();
    }

    public void setApplicationContext(ApplicationContext context) {
        this.m_context = context;
        this.m_blockAccessor = new BlockResourceProvider(context, this);
        this.setupLogger((Object)this.m_blockAccessor, "lifecycle");
    }

    public String[] getBlockNames() {
        return this.m_entries.keySet().toArray(new String[0]);
    }

    public Object getBlock(String name) {
        BlockEntry entry = (BlockEntry)this.m_entries.get(name);
        if (null == entry) {
            return null;
        }
        return entry.getProxy();
    }

    public String getName() {
        return this.m_context.getPartitionProfile().getMetaData().getName();
    }

    public String getDisplayName() {
        return this.m_context.getPartitionProfile().getMetaData().getName();
    }

    public String getDescription() {
        return "The " + this.getDisplayName() + " application.";
    }

    public String getHomeDirectory() {
        return this.m_context.getHomeDirectory().getPath();
    }

    public boolean isRunning() {
        return this.m_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlockListeners() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.m_context.getClassLoader());
        try {
            this.doLoadBlockListeners();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private void doLoadBlockListeners() throws Exception {
        ComponentProfile[] listeners = this.getComponentsInPartition("listener");
        for (int i = 0; i < listeners.length; ++i) {
            try {
                this.startupListener(listeners[i]);
                continue;
            }
            catch (Exception e) {
                String name = listeners[i].getMetaData().getName();
                String message = REZ.getString("bad-listener", (Object)PHASE_STARTUP, (Object)name, (Object)e.getMessage());
                this.getLogger().error(message, (Throwable)e);
                throw e;
            }
        }
    }

    private ComponentProfile[] getComponentsInPartition(String key) {
        PartitionProfile partition = this.m_context.getPartitionProfile().getPartition(key);
        return partition.getComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runPhase(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.m_context.getClassLoader());
        try {
            this.doRunPhase(name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private final void doRunPhase(String name) throws Exception {
        String message;
        ComponentProfile[] blocks = this.getComponentsInPartition("block");
        String[] order = DependencyGraph.walkGraph(PHASE_STARTUP == name, blocks);
        if (this.getLogger().isInfoEnabled()) {
            Integer count = new Integer(blocks.length);
            List<String> pathList = Arrays.asList(order);
            message = REZ.getString("blocks-processing", (Object)count, (Object)name, pathList);
            this.getLogger().info(message);
        }
        if (PHASE_STARTUP == name) {
            PartitionProfile partition = this.m_context.getPartitionProfile();
            File homeDirectory = this.m_context.getHomeDirectory();
            SarMetaData sarMetaData = ComponentMetaDataConverter.toSarMetaData(partition, homeDirectory);
            this.m_listenerSupport.fireApplicationStartingEvent(sarMetaData);
        } else {
            this.m_listenerSupport.applicationStopping();
        }
        for (int i = 0; i < order.length; ++i) {
            String block = order[i];
            if (this.getLogger().isDebugEnabled()) {
                message = REZ.getString("process-block", (Object)block, (Object)name);
                this.getLogger().debug(message);
            }
            try {
                BlockEntry entry = (BlockEntry)this.m_entries.get(block);
                if (PHASE_STARTUP == name) {
                    this.startup(entry);
                } else {
                    this.shutdown(entry);
                }
            }
            catch (Exception e) {
                String message2 = REZ.getString("app.error.run-phase", (Object)name, (Object)block, (Object)e.getMessage());
                this.getLogger().error(message2, (Throwable)e);
                this.m_listenerSupport.applicationFailure(e);
                throw e;
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            message = REZ.getString("processed-block", (Object)block, (Object)name);
            this.getLogger().debug(message);
        }
        if (PHASE_STARTUP == name) {
            this.m_listenerSupport.applicationStarted();
        } else {
            this.m_listenerSupport.applicationStopped();
        }
    }

    private void startup(BlockEntry entry) throws Exception {
        Object block = this.m_lifecycleHelper.startup(entry.getName(), (Object)entry.getProfile(), (ResourceProvider)this.m_blockAccessor);
        this.m_exportHelper.exportBlock(this.m_context, entry.getProfile(), block);
        entry.setObject(block);
        this.m_listenerSupport.fireBlockAddedEvent(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(BlockEntry entry) throws LifecycleException {
        this.m_listenerSupport.fireBlockRemovedEvent(entry);
        Object object = entry.getObject();
        try {
            this.m_exportHelper.unexportBlock(this.m_context, entry.getProfile());
            entry.invalidate();
            this.m_lifecycleHelper.shutdown(entry.getName(), object);
        }
        finally {
            entry.setObject(null);
        }
    }

    private void startupListener(ComponentProfile profile) throws Exception {
        String name = profile.getMetaData().getName();
        Object listener = this.m_lifecycleHelper.startup(name, (Object)profile, (ResourceProvider)this.m_blockAccessor);
        if (listener instanceof ApplicationListener) {
            this.m_listenerSupport.addApplicationListener((ApplicationListener)listener);
        } else {
            this.m_listenerSupport.addBlockListener((BlockListener)listener);
            String message = REZ.getString("helper.isa-blocklistener.error", (Object)name, (Object)profile.getMetaData().getImplementationKey());
            this.getLogger().error(message);
            System.err.println(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

