/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.configuration.merger;

import java.util.HashSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.phoenix.components.configuration.merger.ConfigurationMerger;

public class ConfigurationSplitter {
    public static Configuration split(Configuration merged, Configuration base) throws ConfigurationException {
        DefaultConfiguration layer = ConfigurationSplitter.doSplit(merged, base, false);
        layer.makeReadOnly();
        return layer;
    }

    private static DefaultConfiguration doSplit(Configuration merged, Configuration base, boolean isMerged) throws ConfigurationException {
        DefaultConfiguration layer = new DefaultConfiguration(base.getName(), "Merged [merged: " + merged.getLocation() + ", base: " + base.getLocation() + "]");
        ConfigurationSplitter.copyAttributes(layer, merged, base);
        ConfigurationSplitter.copyValue(layer, merged, base);
        ConfigurationSplitter.copyChildren(layer, merged, base);
        if (isMerged) {
            layer.setAttribute("excalibur-configuration:merge", "true");
        }
        return layer;
    }

    private static DefaultConfiguration doSplit(Configuration merged, Configuration base, String keyAttr) throws ConfigurationException {
        DefaultConfiguration layer = ConfigurationSplitter.doSplit(merged, base, true);
        if (null != keyAttr) {
            layer.setAttribute("excalibur-configuration:key-attribute", keyAttr);
        }
        return layer;
    }

    private static void copyChildren(DefaultConfiguration layer, Configuration merged, Configuration base) throws ConfigurationException {
        Configuration[] kids = merged.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            Configuration mergedWith;
            Configuration mergedChild = kids[i];
            String name = mergedChild.getName();
            Configuration[] mc = merged.getChildren(name);
            Configuration[] bc = base.getChildren(name);
            String keyAttr = null;
            if (bc.length > mc.length) {
                throw new UnsupportedOperationException("Unable to mask children from base in layer");
            }
            if (bc.length == 0) {
                mergedWith = null;
            } else if (mc.length == 1 && bc.length == 1) {
                mergedWith = bc[0];
            } else {
                String keyValue;
                keyAttr = ConfigurationSplitter.findUniqueAttributeName(mc);
                Configuration[] matches = ConfigurationMerger.match(base, name, keyAttr, keyValue = mergedChild.getAttribute(keyAttr));
                if (matches.length == 1) {
                    mergedWith = matches[0];
                } else {
                    throw new ConfigurationException("Multiple children in base with name '" + name + "' and attr '" + keyAttr + " = " + keyValue + "'");
                }
            }
            if (null == mergedWith) {
                layer.addChild(kids[i]);
                continue;
            }
            if (ConfigurationUtil.equals((Configuration)kids[i], mergedWith)) continue;
            DefaultConfiguration layerChild = ConfigurationSplitter.doSplit(kids[i], mergedWith, keyAttr);
            layerChild.makeReadOnly();
            layer.addChild((Configuration)layerChild);
        }
    }

    private static String findUniqueAttributeName(Configuration[] c) throws ConfigurationException {
        HashSet<String> testedAttributes = new HashSet<String>();
        String uniqueAttr = null;
        for (int i = 0; i < c.length; ++i) {
            String[] attrs = c[i].getAttributeNames();
            for (int j = 0; j < attrs.length; ++j) {
                String attr = attrs[j];
                if (!testedAttributes.contains(attr) && ConfigurationSplitter.isUniqueAttribute(attr, c[i].getAttribute(attr), i, c)) {
                    if (null == uniqueAttr) {
                        uniqueAttr = attr;
                        continue;
                    }
                    throw new ConfigurationException("Multiple unique attributes for child [name: " + c[0].getName() + ", unique1: " + uniqueAttr + ", unique2: " + attr + "]");
                }
                testedAttributes.add(attr);
            }
        }
        if (null == uniqueAttr) {
            throw new ConfigurationException("Unable to find unique attribute for children of name: " + c[0].getName());
        }
        return uniqueAttr;
    }

    private static boolean isUniqueAttribute(String attr, String value, int currentConfig, Configuration[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (i == currentConfig) continue;
            try {
                if (!value.equals(c[i].getAttribute(attr))) continue;
                return false;
            }
            catch (ConfigurationException e) {
                return false;
            }
        }
        return true;
    }

    private static void copyValue(DefaultConfiguration layer, Configuration merged, Configuration base) {
        String value = merged.getValue(null);
        if (null != value) {
            try {
                String baseValue = base.getValue();
                if (!value.equals(baseValue)) {
                    layer.setValue(value);
                }
            }
            catch (ConfigurationException e) {
                layer.setValue(value);
            }
        }
    }

    private static void copyAttributes(DefaultConfiguration layer, Configuration merged, Configuration base) throws ConfigurationException {
        String[] mergedAttr = merged.getAttributeNames();
        for (int i = 0; i < mergedAttr.length; ++i) {
            String value = merged.getAttribute(mergedAttr[i]);
            try {
                String baseValue = base.getAttribute(mergedAttr[i]);
                if (value.equals(baseValue)) continue;
                layer.setAttribute(mergedAttr[i], value);
                continue;
            }
            catch (ConfigurationException e) {
                layer.setAttribute(mergedAttr[i], value);
            }
        }
    }
}

