/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.embeddor;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Date;
import java.util.Observer;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.ExtensionFileFilter;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.phoenix.components.embeddor.EmbeddorEntry;
import org.apache.avalon.phoenix.components.embeddor.EmbeddorObservable;
import org.apache.avalon.phoenix.components.embeddor.ManagementRegistration;
import org.apache.avalon.phoenix.interfaces.Deployer;
import org.apache.avalon.phoenix.interfaces.Embeddor;
import org.apache.avalon.phoenix.interfaces.EmbeddorMBean;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.SystemManager;

public class DefaultEmbeddor
extends AbstractLogEnabled
implements Embeddor,
EmbeddorMBean,
Contextualizable,
Parameterizable,
Configurable,
Initializable,
Disposable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor == null ? (class$org$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor = DefaultEmbeddor.class$("org.apache.avalon.phoenix.components.embeddor.DefaultEmbeddor")) : class$org$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor));
    private static final String DEFAULT_APPS_PATH = "/apps";
    private final EmbeddorObservable m_observable = new EmbeddorObservable();
    private Parameters m_parameters;
    private Context m_context;
    private String m_phoenixHome;
    private EmbeddorEntry[] m_entries;
    private boolean m_persistent;
    private boolean m_shutdown;
    private long m_startTime;
    private String m_appDir;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor;
    static /* synthetic */ Class class$java$util$Observer;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
        try {
            Observer observer = (Observer)context.get((Object)(class$java$util$Observer == null ? (class$java$util$Observer = DefaultEmbeddor.class$("java.util.Observer")) : class$java$util$Observer).getName());
            this.m_observable.addObserver(observer);
        }
        catch (ContextException ce) {
            String message = REZ.getString("embeddor.notice.no-restart");
            this.getLogger().warn(message);
        }
    }

    public synchronized void parameterize(Parameters parameters) throws ParameterException {
        this.m_parameters = parameters;
        this.m_phoenixHome = this.m_parameters.getParameter("phoenix.home", "..");
        this.m_persistent = this.m_parameters.getParameterAsBoolean("persistent", false);
        this.m_appDir = this.m_parameters.getParameter("phoenix.apps.dir", this.m_phoenixHome + DEFAULT_APPS_PATH);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] children = configuration.getChildren("component");
        this.m_entries = new EmbeddorEntry[children.length];
        for (int i = 0; i < children.length; ++i) {
            String role = children[i].getAttribute("role", null);
            String classname = children[i].getAttribute("class");
            String logger = children[i].getAttribute("logger");
            this.m_entries[i] = new EmbeddorEntry(role, classname, logger, children[i]);
        }
    }

    public void initialize() throws Exception {
        this.m_startTime = System.currentTimeMillis();
        try {
            this.createComponents();
            this.setupComponents();
            this.registerComponents();
        }
        catch (Exception e) {
            String message = REZ.getString("embeddor.error.start.failed");
            this.getLogger().fatalError(message, (Throwable)e);
            throw e;
        }
    }

    public void execute() throws Exception {
        this.deployDefaultApplications();
        if (this.emptyKernel()) {
            String message = REZ.getString("embeddor.error.start.no-apps");
            this.getLogger().fatalError(message);
        } else {
            while (true) {
                if (this.m_shutdown || this.emptyKernel() && !this.m_persistent) {
                    if (!this.emptyKernel()) break;
                    String message = REZ.getString("embeddor.shutdown.all-apps-disposed");
                    this.getLogger().info(message);
                    break;
                }
                this.gotoSleep();
            }
        }
    }

    private boolean emptyKernel() {
        Kernel kernel = this.getKernel();
        if (null != kernel) {
            String[] names = kernel.getApplicationNames();
            return 0 == names.length;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoSleep() {
        try {
            DefaultEmbeddor defaultEmbeddor = this;
            synchronized (defaultEmbeddor) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void dispose() {
        this.shutdown();
        try {
            this.unregisterComponents();
            this.shutdownComponents();
        }
        catch (Exception e) {
            String message = REZ.getString("embeddor.error.shutdown.failed");
            this.getLogger().fatalError(message, (Throwable)e);
        }
        for (int i = 0; i < this.m_entries.length; ++i) {
            this.m_entries[i].setObject(null);
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.m_shutdown = true;
        DefaultEmbeddor defaultEmbeddor = this;
        synchronized (defaultEmbeddor) {
            this.notifyAll();
        }
    }

    public void restart() throws UnsupportedOperationException {
        try {
            this.m_observable.change();
            this.m_observable.notifyObservers("restart");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public String getName() {
        return "Phoenix";
    }

    public String getHomeDirectory() {
        return this.m_phoenixHome;
    }

    public Date getStartTime() {
        return new Date(this.m_startTime);
    }

    public long getUpTimeInMillis() {
        return System.currentTimeMillis() - this.m_startTime;
    }

    public String getVersion() {
        return "4.2";
    }

    public String getBuild() {
        return "(January 21 2006)";
    }

    private synchronized void createComponents() throws Exception {
        try {
            for (int i = 0; i < this.m_entries.length; ++i) {
                String className = this.m_entries[i].getClassName();
                Class<?> clazz = Class.forName(className);
                Object object = this.createObject(className, clazz);
                this.m_entries[i].setObject(object);
            }
        }
        catch (Exception e) {
            String message = REZ.getString("embeddor.error.createComponents.failed");
            this.getLogger().fatalError(message, (Throwable)e);
            throw new CascadingException(message, (Throwable)e);
        }
    }

    protected void deployDefaultApplications() throws Exception {
        ExtensionFileFilter filter;
        File directory;
        File[] files;
        String application = this.m_parameters.getParameter("application-location", null);
        if (null != application) {
            File file = new File(application);
            this.deployFile(file);
        }
        if (null != this.m_appDir && null != (files = (directory = new File(this.m_appDir)).listFiles((FilenameFilter)(filter = new ExtensionFileFilter(".sar"))))) {
            this.deployFiles(files);
        }
    }

    private void deployFiles(File[] files) throws Exception {
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            this.deployFile(files[i]);
        }
    }

    private void deployFile(File file) throws Exception {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            index = filename.length();
        }
        String name = filename.substring(0, index);
        File canonicalFile = file.getCanonicalFile();
        this.deployFile(name, canonicalFile);
    }

    protected final synchronized void deployFile(String name, File file) throws Exception {
        Deployer deployer = (Deployer)this.getEmbeddorComponent(Deployer.ROLE);
        deployer.deploy(name, file.toURL());
    }

    private void setupComponents() throws Exception {
        for (int i = 0; i < this.m_entries.length; ++i) {
            EmbeddorEntry entry = this.m_entries[i];
            this.setupComponent(entry.getObject(), entry.getLoggerName(), entry.getConfiguration());
        }
    }

    private void setupComponent(Object object, String loggerName, Configuration config) throws Exception {
        Logger childLogger = this.getLogger().getChildLogger(loggerName);
        ContainerUtil.enableLogging((Object)object, (Logger)childLogger);
        ContainerUtil.contextualize((Object)object, (Context)this.m_context);
        ContainerUtil.service((Object)object, (ServiceManager)this.getServiceManager());
        ContainerUtil.parameterize((Object)object, (Parameters)this.createChildParameters());
        ContainerUtil.configure((Object)object, (Configuration)config);
        ContainerUtil.initialize((Object)object);
        ContainerUtil.start((Object)object);
    }

    private Parameters createChildParameters() {
        Parameters parameters = new Parameters();
        parameters.merge(this.m_parameters);
        parameters.setParameter("phoenix.apps.dir", this.m_appDir);
        return parameters;
    }

    private void shutdownComponents() throws Exception {
        for (int i = 0; i < this.m_entries.length; ++i) {
            Object object = this.m_entries[i].getObject();
            if (null == object) continue;
            ContainerUtil.shutdown((Object)object);
        }
    }

    private Object createObject(String classname, Class service) throws Exception {
        try {
            Object object = Class.forName(classname).newInstance();
            if (!service.isInstance(object)) {
                String message = REZ.getString("bad-type.error", (Object)classname, (Object)service.getName());
                throw new Exception(message);
            }
            return object;
        }
        catch (IllegalAccessException iae) {
            String message = REZ.getString("bad-ctor.error", (Object)service.getName(), (Object)classname);
            throw new CascadingException(message, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            String message = REZ.getString("no-instantiate.error", (Object)service.getName(), (Object)classname);
            throw new CascadingException(message, (Throwable)ie);
        }
        catch (ClassNotFoundException cnfe) {
            String message = REZ.getString("no-class.error", (Object)service.getName(), (Object)classname);
            throw new CascadingException(message, (Throwable)cnfe);
        }
    }

    private void registerComponents() throws Exception {
        SystemManager systemManager = (SystemManager)this.getServiceManager().lookup(SystemManager.ROLE);
        SystemManager componentManager = systemManager.getSubContext(null, "component");
        componentManager.register(ManagementRegistration.EMBEDDOR.getName(), this, ManagementRegistration.EMBEDDOR.getInterfaces());
        for (int i = 0; i < this.m_entries.length; ++i) {
            ManagementRegistration registration;
            String role = this.m_entries[i].getRole();
            if (null == role || null == (registration = ManagementRegistration.getManagementInfoForRole(role))) continue;
            componentManager.register(registration.getName(), this.m_entries[i].getObject(), registration.getInterfaces());
        }
    }

    private void unregisterComponents() throws Exception {
        SystemManager systemManager = (SystemManager)this.getServiceManager().lookup(SystemManager.ROLE);
        SystemManager componentManager = systemManager.getSubContext(null, "component");
        componentManager.unregister(ManagementRegistration.EMBEDDOR.getName());
        for (int i = 0; i < this.m_entries.length; ++i) {
            ManagementRegistration registration;
            String role = this.m_entries[i].getRole();
            if (null == role || null == (registration = ManagementRegistration.getManagementInfoForRole(role))) continue;
            componentManager.unregister(registration.getName());
        }
    }

    private ServiceManager getServiceManager() {
        DefaultServiceManager serviceManager = new DefaultServiceManager();
        serviceManager.put(Embeddor.ROLE, (Object)this);
        for (int i = 0; i < this.m_entries.length; ++i) {
            String role = this.m_entries[i].getRole();
            if (null == role) continue;
            Object component = this.getEmbeddorComponent(role);
            serviceManager.put(role, component);
        }
        return serviceManager;
    }

    protected final Kernel getKernel() {
        return (Kernel)this.getEmbeddorComponent(Kernel.ROLE);
    }

    protected final Parameters getParameters() {
        return this.m_parameters;
    }

    private Object getEmbeddorComponent(String role) {
        for (int i = 0; i < this.m_entries.length; ++i) {
            EmbeddorEntry entry = this.m_entries[i];
            String candidate = entry.getRole();
            if (null == candidate || !candidate.equals(role)) continue;
            return this.m_entries[i].getObject();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

