/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.components.manager.Target;
import org.apache.avalon.phoenix.tools.configuration.ConfigurationBuilder;
import org.xml.sax.InputSource;

public final class MBeanInfoBuilder
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$manager$MBeanInfoBuilder == null ? (class$org$apache$avalon$phoenix$components$manager$MBeanInfoBuilder = MBeanInfoBuilder.class$("org.apache.avalon.phoenix.components.manager.MBeanInfoBuilder")) : class$org$apache$avalon$phoenix$components$manager$MBeanInfoBuilder));
    private static final String REQ_MODEL_MBEAN = (class$javax$management$modelmbean$RequiredModelMBean == null ? (class$javax$management$modelmbean$RequiredModelMBean = MBeanInfoBuilder.class$("javax.management.modelmbean.RequiredModelMBean")) : class$javax$management$modelmbean$RequiredModelMBean).getName();
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$manager$MBeanInfoBuilder;
    static /* synthetic */ Class class$javax$management$modelmbean$RequiredModelMBean;

    public void build(Target target, Class managedClass, Class[] interfaces) throws ConfigurationException {
        String notice = REZ.getString("mxinfo.debug.building", (Object)managedClass.getName());
        this.getLogger().debug(notice);
        Configuration config = this.loadMxInfo(managedClass);
        if (null != config) {
            String message = REZ.getString("mxinfo.debug.found.mxinfo", (Object)managedClass.getName());
            this.getLogger().debug(message);
            this.buildFromMxInfo(target, managedClass, config);
        }
        int j = interfaces.length;
        for (int i = 0; i < j; ++i) {
            try {
                config = this.loadMxInfo(interfaces[i]);
                if (config == null) {
                    this.buildFromIntrospection(target, interfaces[i]);
                    continue;
                }
                this.buildFromMxInfo(target, managedClass, config);
                continue;
            }
            catch (Exception e) {
                String message = REZ.getString("mxinfo.error.target", (Object)target.getName());
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message);
            }
        }
    }

    private void buildFromMxInfo(Target target, Class managedClass, Configuration config) throws ConfigurationException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(managedClass);
        }
        catch (Exception e) {
            String message = REZ.getString("mxinfo.error.introspect", (Object)managedClass.getName());
            throw new ConfigurationException(message, (Throwable)e);
        }
        Configuration[] topicsConfig = config.getChildren("topic");
        for (int i = 0; i < topicsConfig.length; ++i) {
            ModelMBeanInfoSupport topic = this.buildTopic(topicsConfig[i], beanInfo);
            target.addTopic(topic);
        }
        Configuration[] proxysConfig = config.getChildren("proxy");
        for (int i = 0; i < proxysConfig.length; ++i) {
            ModelMBeanInfoSupport topic = this.buildProxyTopic(proxysConfig[i], managedClass);
            target.addTopic(topic);
        }
    }

    private void buildFromIntrospection(Target target, Class interfaceClass) throws ConfigurationException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(interfaceClass);
            MethodDescriptor[] methods = beanInfo.getMethodDescriptors();
            ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
            for (int j = 0; j < methods.length; ++j) {
                String name = methods[j].getName();
                if (name.startsWith("get") || name.startsWith("set") || name.startsWith("is")) continue;
                operations.add(this.buildOperationInfo(methods[j], null));
            }
            ModelMBeanOperationInfo[] operationList = operations.toArray(new ModelMBeanOperationInfo[0]);
            PropertyDescriptor[] propertys = beanInfo.getPropertyDescriptors();
            ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[propertys.length];
            for (int j = 0; j < propertys.length; ++j) {
                attributes[j] = this.buildAttributeInfo(propertys[j], null);
            }
            ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[]{};
            ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[]{};
            String shortName = this.getShortName(interfaceClass.getName());
            ModelMBeanInfoSupport topic = new ModelMBeanInfoSupport(REQ_MODEL_MBEAN, shortName, attributes, constructors, operationList, notifications);
            String message = REZ.getString("mxinfo.debug.adding.topic", (Object)topic.getDescription());
            this.getLogger().debug(message);
            target.addTopic(topic);
        }
        catch (Exception e) {
            String message = REZ.getString("mxinfo.error.topic", (Object)interfaceClass);
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    private ModelMBeanInfoSupport buildTopic(Configuration config, BeanInfo beanInfo) throws ConfigurationException {
        ModelMBeanAttributeInfo[] attributes = this.buildAttributeInfos(config, beanInfo);
        ModelMBeanOperationInfo[] operations = this.buildOperationInfos(config, beanInfo);
        ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[]{};
        ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[]{};
        String name = config.getAttribute("name");
        ModelMBeanInfoSupport topic = new ModelMBeanInfoSupport(REQ_MODEL_MBEAN, name, attributes, constructors, operations, notifications);
        return topic;
    }

    private ModelMBeanInfoSupport buildProxyTopic(Configuration proxyTagConfig, Class managedClass) throws ConfigurationException {
        try {
            String proxyName = proxyTagConfig.getAttribute("name");
            String message = REZ.getString("mxinfo.debug.building.proxy.topic", (Object)proxyName);
            this.getLogger().debug(message);
            Class<?> proxyClass = managedClass.getClassLoader().loadClass(proxyName);
            Configuration classConfig = this.loadMxInfo(proxyClass);
            Configuration topicConfig = classConfig.getChild("topic");
            BeanInfo info = Introspector.getBeanInfo(proxyClass);
            ModelMBeanInfoSupport topic = this.buildTopic(topicConfig, info);
            Descriptor mBeanDescriptor = topic.getMBeanDescriptor();
            mBeanDescriptor.setField("proxyClassName", proxyName);
            topic.setMBeanDescriptor(mBeanDescriptor);
            return topic;
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)e);
            }
            String message = REZ.getString("mxinfo.error.proxy", (Object)managedClass.getName());
            throw new ConfigurationException(message);
        }
    }

    private ModelMBeanAttributeInfo[] buildAttributeInfos(Configuration config, BeanInfo info) throws ConfigurationException {
        Configuration[] attributesConfig = config.getChildren("attribute");
        ModelMBeanAttributeInfo[] attributeList = new ModelMBeanAttributeInfo[attributesConfig.length];
        PropertyDescriptor[] propertys = info.getPropertyDescriptors();
        for (int i = 0; i < attributesConfig.length; ++i) {
            Configuration attribute = attributesConfig[i];
            String name = attribute.getAttribute("name");
            PropertyDescriptor property = this.getPropertyDescriptor(name, propertys);
            attributeList[i] = this.buildAttributeInfo(property, attribute);
        }
        return attributeList;
    }

    private ModelMBeanAttributeInfo buildAttributeInfo(PropertyDescriptor property, Configuration config) {
        boolean isWriteable;
        String name = property.getName();
        Method readMethod = property.getReadMethod();
        Method writeMethod = property.getWriteMethod();
        String type = property.getPropertyType().getName();
        String description = property.getDisplayName();
        boolean isReadable = readMethod != null;
        boolean bl = isWriteable = writeMethod != null;
        if (config != null) {
            description = config.getAttribute("description", description);
            isReadable = config.getAttributeAsBoolean("isReadable", true) && isReadable;
            isWriteable = config.getAttributeAsBoolean("isWriteable", true) && isWriteable;
        }
        boolean isIs = readMethod != null && readMethod.getName().startsWith("is");
        ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWriteable, isIs);
        Descriptor descriptor = info.getDescriptor();
        descriptor.setField("currencyTimeLimit", new Integer(1));
        if (null != readMethod) {
            descriptor.setField("getMethod", readMethod.getName());
        }
        if (null != writeMethod) {
            descriptor.setField("setMethod", writeMethod.getName());
        }
        info.setDescriptor(descriptor);
        return info;
    }

    private PropertyDescriptor getPropertyDescriptor(String name, PropertyDescriptor[] propertys) throws ConfigurationException {
        for (int i = 0; i < propertys.length; ++i) {
            if (!propertys[i].getName().equals(name)) continue;
            return propertys[i];
        }
        String message = REZ.getString("mxinfo.error.missing.property", (Object)name);
        throw new ConfigurationException(message);
    }

    private ModelMBeanOperationInfo[] buildOperationInfos(Configuration config, BeanInfo info) throws ConfigurationException {
        Configuration[] operationsConfig = config.getChildren("operation");
        ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[operationsConfig.length];
        MethodDescriptor[] methodDescriptors = info.getMethodDescriptors();
        for (int i = 0; i < operationsConfig.length; ++i) {
            Configuration operation = operationsConfig[i];
            String name = operation.getAttribute("name");
            MethodDescriptor method = this.getMethodDescriptor(name, methodDescriptors);
            operations[i] = this.buildOperationInfo(method, operation);
        }
        return operations;
    }

    private ModelMBeanOperationInfo buildOperationInfo(MethodDescriptor method, Configuration config) throws ConfigurationException {
        ModelMBeanOperationInfo info;
        if (config == null) {
            info = new ModelMBeanOperationInfo(method.getDisplayName(), method.getMethod());
        } else {
            String name = method.getName();
            String type = method.getMethod().getReturnType().getName();
            String description = config.getAttribute("description", method.getDisplayName());
            int impact = config.getAttributeAsInteger("impact", 3);
            Configuration[] paramConfig = config.getChildren("param");
            MBeanParameterInfo[] params = new MBeanParameterInfo[paramConfig.length];
            for (int i = 0; i < paramConfig.length; ++i) {
                params[i] = this.buildParameterInfo(paramConfig[i]);
            }
            info = new ModelMBeanOperationInfo(name, description, params, type, impact);
        }
        Descriptor descriptor = info.getDescriptor();
        descriptor.setField("currencyTimeLimit", new Integer(0));
        info.setDescriptor(descriptor);
        return info;
    }

    private MethodDescriptor getMethodDescriptor(String name, MethodDescriptor[] methods) throws ConfigurationException {
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        String message = REZ.getString("mxinfo.error.missing.method", (Object)name);
        throw new ConfigurationException(message);
    }

    private MBeanParameterInfo buildParameterInfo(Configuration paramConfig) throws ConfigurationException {
        String name = paramConfig.getAttribute("name");
        String description = paramConfig.getAttribute("description");
        String type = paramConfig.getAttribute("type");
        return new MBeanParameterInfo(name, type, description);
    }

    private Configuration loadMxInfo(Class clazz) throws ConfigurationException {
        String mxinfoName = "/" + clazz.getName().replace('.', '/') + ".mxinfo";
        try {
            InputStream stream = clazz.getResourceAsStream(mxinfoName);
            if (null == stream) {
                return null;
            }
            InputSource source = new InputSource(stream);
            return ConfigurationBuilder.build((InputSource)source, (String)"-//PHOENIX/Mx Info DTD Version 1.0//EN", (Logger)this.getLogger());
        }
        catch (Exception e) {
            String message = REZ.getString("mxinfo.error.file", (Object)mxinfoName);
            this.getLogger().error(message, (Throwable)e);
            throw new ConfigurationException(message);
        }
    }

    private String getShortName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

