/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.monitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.excalibur.monitor.DirectoryResource;
import org.apache.avalon.excalibur.monitor.Resource;
import org.apache.avalon.excalibur.monitor.impl.ActiveMonitor;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.interfaces.Deployer;

public class DefaultDeploymentMonitor
extends AbstractLogEnabled
implements LogEnabled,
Parameterizable,
Configurable,
Serviceable,
Startable,
PropertyChangeListener {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$monitor$DefaultDeploymentMonitor == null ? (class$org$apache$avalon$phoenix$components$monitor$DefaultDeploymentMonitor = DefaultDeploymentMonitor.class$("org.apache.avalon.phoenix.components.monitor.DefaultDeploymentMonitor")) : class$org$apache$avalon$phoenix$components$monitor$DefaultDeploymentMonitor));
    private String m_appsDir;
    private ActiveMonitor m_monitor;
    private Deployer m_deployer;
    private long m_frequency;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$monitor$DefaultDeploymentMonitor;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_appsDir = parameters.getParameter("phoenix.apps.dir");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_frequency = configuration.getChild("scanner-frequency").getValueAsLong(1000L);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_deployer = (Deployer)manager.lookup(Deployer.ROLE);
    }

    public void start() throws Exception {
        DirectoryResource resource = new DirectoryResource(this.m_appsDir);
        resource.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_monitor = new ActiveMonitor();
        this.m_monitor.setFrequency(this.m_frequency);
        this.m_monitor.addResource((Resource)resource);
        this.m_monitor.start();
    }

    public void stop() throws Exception {
        this.m_monitor.stop();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Set newValue = (Set)event.getNewValue();
        Set deployments = this.getDeployments(newValue);
        Iterator iterator = deployments.iterator();
        if (name.equals("AddedFiles")) {
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                this.deployApplication(file);
            }
        } else if (name.equals("DeletedFiles")) {
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                this.undeployApplication(file);
            }
        } else {
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                this.redeployApplication(file);
            }
        }
    }

    private void deployApplication(File file) {
        String name = FileUtil.removeExtension((String)file.getName());
        try {
            String message = REZ.getString("scanner.deploy.notice", (Object)name, (Object)file);
            this.getLogger().info(message);
            this.m_deployer.deploy(name, file.toURL());
        }
        catch (Exception e) {
            String message = REZ.getString("scanner.no-deploy.error", (Object)file, (Object)e);
            this.getLogger().warn(message, (Throwable)e);
        }
    }

    private void undeployApplication(File file) {
        String name = FileUtil.removeExtension((String)file.getName());
        try {
            String message = REZ.getString("scanner.undeploy.notice", (Object)name);
            this.getLogger().info(message);
            this.m_deployer.undeploy(name);
        }
        catch (Exception e) {
            String message = REZ.getString("scanner.no-undeploy.error", (Object)file, (Object)e);
            this.getLogger().warn(message, (Throwable)e);
        }
    }

    private void redeployApplication(File file) {
        String name = FileUtil.removeExtension((String)file.getName());
        try {
            String message = REZ.getString("scanner.redeploy.notice", (Object)name, (Object)file);
            this.getLogger().info(message);
            this.m_deployer.redeploy(name, file.toURL());
        }
        catch (Exception e) {
            String message = REZ.getString("scanner.no-redeploy.error", (Object)file, (Object)e);
            this.getLogger().warn(message, (Throwable)e);
        }
    }

    private Set getDeployments(Set newValue) {
        HashSet<File> deployments = new HashSet<File>();
        Iterator iterator = newValue.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (this.isDeployment(file)) {
                deployments.add(file);
                continue;
            }
            String message = REZ.getString("scanner.skipping-file.notice", (Object)file);
            this.getLogger().info(message);
        }
        return deployments;
    }

    private boolean isDeployment(File file) {
        return !file.isDirectory() && file.getName().endsWith(".sar");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

