/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.util;

import java.io.File;
import java.util.ArrayList;
import org.apache.avalon.phoenix.components.util.ComponentInfoConverter;
import org.apache.avalon.phoenix.containerkit.metadata.ComponentMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.avalon.phoenix.metainfo.BlockInfo;

public class ComponentMetaDataConverter {
    private ComponentMetaDataConverter() {
    }

    public static SarMetaData toSarMetaData(PartitionProfile partition, File homeDirectory) {
        PartitionProfile blockPartition = partition.getPartition("block");
        PartitionProfile listenerPartition = partition.getPartition("listener");
        BlockListenerMetaData[] listeners = ComponentMetaDataConverter.toBlockListeners(listenerPartition.getMetaData().getComponents());
        BlockMetaData[] blocks = ComponentMetaDataConverter.toBlocks(blockPartition.getComponents());
        return new SarMetaData(partition.getMetaData().getName(), homeDirectory, blocks, listeners);
    }

    private static BlockMetaData[] toBlocks(ComponentProfile[] components) {
        ArrayList<BlockMetaData> listenerSet = new ArrayList<BlockMetaData>();
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile component = components[i];
            BlockMetaData block = ComponentMetaDataConverter.toBlockMetaData(component.getMetaData(), component.getInfo());
            listenerSet.add(block);
        }
        return listenerSet.toArray(new BlockMetaData[listenerSet.size()]);
    }

    public static BlockListenerMetaData[] toBlockListeners(ComponentMetaData[] listeners) {
        ArrayList<BlockListenerMetaData> listenerSet = new ArrayList<BlockListenerMetaData>();
        for (int i = 0; i < listeners.length; ++i) {
            BlockListenerMetaData listener = new BlockListenerMetaData(listeners[i].getName(), listeners[i].getImplementationKey());
            listenerSet.add(listener);
        }
        return listenerSet.toArray(new BlockListenerMetaData[listenerSet.size()]);
    }

    public static BlockMetaData toBlockMetaData(ComponentMetaData component, ComponentInfo info) {
        boolean disableProxy = ComponentMetaDataConverter.isDisableProxy(component);
        DependencyMetaData[] dependencies = ComponentMetaDataConverter.toPhoenixDependencys(component.getDependencies());
        BlockInfo blockInfo = ComponentInfoConverter.toBlockInfo(info);
        return new BlockMetaData(component.getName(), dependencies, disableProxy, blockInfo);
    }

    private static boolean isDisableProxy(ComponentMetaData component) {
        Attribute[] attributes = component.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!attribute.getName().equals("phoenix:disable-proxy")) continue;
            return true;
        }
        return false;
    }

    private static DependencyMetaData[] toPhoenixDependencys(org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData[] dependencies) {
        ArrayList<DependencyMetaData> depends = new ArrayList<DependencyMetaData>();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyMetaData dependency = new DependencyMetaData(dependencies[i].getProviderName(), dependencies[i].getKey(), dependencies[i].getAlias());
            depends.add(dependency);
        }
        return depends.toArray(new DependencyMetaData[depends.size()]);
    }
}

