/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.ant;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractQdoxTask
extends Task {
    private Vector filesets = new Vector();
    protected HashMap fileMap = new HashMap();
    protected ArrayList allSources = new ArrayList();
    protected ArrayList allClasses = new ArrayList();

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void buildFileMap() {
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            this.buildFileMap(fs.getDir(this.getProject()), srcFiles);
            ++i;
        }
    }

    protected void buildFileMap(File directory, String[] sourceFiles) {
        int i = 0;
        while (i < sourceFiles.length) {
            File src = new File(directory, sourceFiles[i]);
            this.fileMap.put(src.getAbsolutePath(), src);
            ++i;
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.buildFileMap();
        JavaDocBuilder builder = new JavaDocBuilder();
        this.mergeBuilderSources(builder);
        JavaSource[] sources = builder.getSources();
        this.processSources(sources);
    }

    private void mergeBuilderSources(JavaDocBuilder builder) {
        Iterator iterator = this.fileMap.keySet().iterator();
        while (iterator.hasNext()) {
            String sourceFile = (String)iterator.next();
            builder.addSourceTree((File)this.fileMap.get(sourceFile));
        }
    }

    protected void processSources(JavaSource[] sources) {
        int i = 0;
        while (i < sources.length) {
            JavaSource source = sources[i];
            this.allSources.add(source);
            JavaClass[] classes = source.getClasses();
            this.processClasses(classes);
            ++i;
        }
    }

    protected void processClasses(JavaClass[] classes) {
        int j = 0;
        while (j < classes.length) {
            JavaClass clazz = classes[j];
            this.allClasses.add(clazz);
            ++j;
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source fileset.");
        }
    }
}

