/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JavaClass
extends AbstractJavaEntity
implements JavaClassParent {
    private List methods = new LinkedList();
    private JavaMethod[] methodsArray;
    private List fields = new LinkedList();
    private JavaField[] fieldsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private boolean interfce;
    private Type type;
    private Type superClass;
    private Type[] implementz = new Type[0];
    private JavaClassParent parent;
    public static final Type OBJECT = new Type("java.lang.Object", 0);
    private JavaClassCache javaClassCache;

    public void setJavaClassCache(JavaClassCache javaClassCache) {
        this.javaClassCache = javaClassCache;
    }

    public boolean isInterface() {
        return this.interfce;
    }

    public Type getSuperClass() {
        if (!this.interfce && this.superClass == null) {
            return OBJECT;
        }
        return this.superClass;
    }

    public JavaClass getSuperJavaClass() {
        if (this.javaClassCache == null) {
            throw new UnsupportedOperationException("JavaClassCache unavailable for this JavaClass");
        }
        return this.javaClassCache.getClassByName(this.getSuperClass().getValue());
    }

    public Type[] getImplements() {
        return this.implementz;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeAccessibilityModifier(result);
        this.writeNonAccessibilityModifiers(result);
        result.write(this.interfce ? "interface " : "class ");
        result.write(this.name);
        if (this.superClass != null) {
            result.write(" extends ");
            result.write(this.superClass.getValue());
        }
        if (this.implementz.length > 0) {
            result.write(this.interfce ? " extends " : " implements ");
            int i = 0;
            while (i < this.implementz.length) {
                if (i > 0) {
                    result.write(", ");
                }
                result.write(this.implementz[i].getValue());
                ++i;
            }
        }
        result.write(" {");
        result.newline();
        result.indent();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            JavaField javaField = (JavaField)iterator.next();
            result.newline();
            javaField.write(result);
        }
        Iterator iterator2 = this.methods.iterator();
        while (iterator2.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator2.next();
            result.newline();
            javaMethod.write(result);
        }
        result.deindent();
        result.newline();
        result.write('}');
        result.newline();
    }

    public void setInterface(boolean interfce) {
        this.interfce = interfce;
    }

    public void addMethod(JavaMethod meth) {
        this.methods.add(meth);
        meth.setParentClass(this);
        this.methodsArray = null;
    }

    public void setSuperClass(Type type) {
        this.superClass = type;
    }

    public void setImplementz(Type[] implementz) {
        this.implementz = implementz;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
        javaField.setParentClass(this);
        this.fieldsArray = null;
    }

    public void setParent(JavaClassParent parent) {
        this.parent = parent;
    }

    public JavaClassParent getParent() {
        return this.parent;
    }

    public JavaSource getParentSource() {
        JavaClassParent parent = this.getParent();
        return parent == null ? null : parent.getParentSource();
    }

    public String getPackage() {
        return this.getParentSource().getPackage();
    }

    public String getFullyQualifiedName() {
        return this.getParent().asClassNamespace() + "." + this.getName();
    }

    public String asClassNamespace() {
        return this.getFullyQualifiedName();
    }

    public Type asType() {
        if (this.type == null) {
            this.type = new Type(this.getFullyQualifiedName(), 0);
        }
        return this.type;
    }

    public JavaMethod[] getMethods() {
        if (this.methodsArray == null) {
            this.methodsArray = new JavaMethod[this.methods.size()];
            this.methods.toArray(this.methodsArray);
        }
        return this.methodsArray;
    }

    public JavaField[] getFields() {
        if (this.fieldsArray == null) {
            this.fieldsArray = new JavaField[this.fields.size()];
            this.fields.toArray(this.fieldsArray);
        }
        return this.fieldsArray;
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
        cls.setParent(this);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }
}

