/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.OutputStream;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.excalibur.logger.factory.FormatterFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;

public class StreamTargetFactory
extends AbstractTargetFactory
implements Contextualizable {
    public LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        OutputStream stream;
        Configuration streamConfig = configuration.getChild("stream", false);
        if (null == streamConfig) {
            stream = System.err;
        } else {
            String streamName = streamConfig.getValue();
            try {
                stream = (OutputStream)this.m_context.get((Object)streamName);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error resolving stream '" + streamName + "' at " + streamConfig.getLocation(), (Throwable)e);
            }
        }
        Configuration formatterConf = configuration.getChild("format");
        Formatter formatter = this.getFormatter(formatterConf);
        return new StreamTarget(stream, formatter);
    }

    public void contextualize(Context context) throws ContextException {
        DefaultContext newContext = new DefaultContext(context);
        newContext.put((Object)"System.out", (Object)System.out);
        newContext.put((Object)"System.err", (Object)System.err);
        super.contextualize((Context)newContext);
    }

    protected Formatter getFormatter(Configuration conf) {
        Formatter formatter = null;
        if (null != conf) {
            FormatterFactory formatterFactory = new FormatterFactory();
            formatter = formatterFactory.createFormatter(conf);
        }
        return formatter;
    }
}

