/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.cli;

public final class CLOptionDescriptor {
    public static final int ARGUMENT_REQUIRED = 2;
    public static final int ARGUMENT_OPTIONAL = 4;
    public static final int ARGUMENT_DISALLOWED = 8;
    public static final int ARGUMENTS_REQUIRED_2 = 16;
    public static final int DUPLICATES_ALLOWED = 32;
    private final int m_id;
    private final int m_flags;
    private final String m_name;
    private final String m_description;
    private final int[] m_incompatible;

    public CLOptionDescriptor(String name, int flags, int id, String description) {
        int[] nArray;
        if ((flags & 0x20) > 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = id;
        }
        this(name, flags, id, description, nArray);
    }

    public CLOptionDescriptor(String name, int flags, int id, String description, int[] incompatible) {
        this.m_id = id;
        this.m_name = name;
        this.m_flags = flags;
        this.m_description = description;
        this.m_incompatible = incompatible;
        int modeCount = 0;
        if ((2 & flags) == 2) {
            ++modeCount;
        }
        if ((4 & flags) == 4) {
            ++modeCount;
        }
        if ((8 & flags) == 8) {
            ++modeCount;
        }
        if ((0x10 & flags) == 16) {
            ++modeCount;
        }
        if (0 == modeCount) {
            String message = "No mode specified for option " + this;
            throw new IllegalStateException(message);
        }
        if (1 != modeCount) {
            String message = "Multiple modes specified for option " + this;
            throw new IllegalStateException(message);
        }
    }

    public CLOptionDescriptor(String name, int flags, int id, String description, CLOptionDescriptor[] incompatible) {
        this.m_id = id;
        this.m_name = name;
        this.m_flags = flags;
        this.m_description = description;
        this.m_incompatible = new int[incompatible.length];
        int i = 0;
        while (i < incompatible.length) {
            this.m_incompatible[i] = incompatible[i].getId();
            ++i;
        }
    }

    protected final int[] getIncompatble() {
        return this.getIncompatible();
    }

    protected final int[] getIncompatible() {
        return this.m_incompatible;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final int getId() {
        return this.m_id;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OptionDescriptor ");
        sb.append(this.m_name);
        sb.append("[OptionDescriptor ");
        sb.append(this.m_name);
        sb.append(", ");
        sb.append(this.m_id);
        sb.append(", ");
        sb.append(this.m_flags);
        sb.append(", ");
        sb.append(this.m_description);
        sb.append(" ]");
        return sb.toString();
    }

    static {
        ARGUMENT_REQUIRED = 2;
        ARGUMENT_OPTIONAL = 4;
        ARGUMENT_DISALLOWED = 8;
        ARGUMENTS_REQUIRED_2 = 16;
        DUPLICATES_ALLOWED = 32;
    }
}

