/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.impl;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.bind.JAXBElement;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.ObjectFactory;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.IdentifiableType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.xd.transform.XdmXdsTransformer;
import org.nhindirect.xd.transform.exception.TransformationException;
import org.nhindirect.xd.transform.util.XmlUtils;
import org.nhindirect.xd.transform.util.type.MimeType;

public class DefaultXdmXdsTransformer
implements XdmXdsTransformer {
    private static String XDM_FILENAME_DATA = "DOCUMENT.xml";
    private static final String XDM_FILENAME_METADATA = "METADATA.xml";
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultXdmXdsTransformer.class);

    @Override
    public ProvideAndRegisterDocumentSetRequestType transform(File file) throws TransformationException {
        LOGGER.trace((Object)"Begin transformation of XDM to XDS (file)");
        String docId = null;
        ZipFile zipFile = null;
        String docName = this.getDocName(file);
        if (docName != null) {
            XDM_FILENAME_DATA = docName;
        }
        ProvideAndRegisterDocumentSetRequestType prsr = new ProvideAndRegisterDocumentSetRequestType();
        try {
            zipFile = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            ZipEntry zipEntry = null;
            while (zipEntries.hasMoreElements()) {
                zipEntry = zipEntries.nextElement();
                String zname = zipEntry.getName();
                LOGGER.trace((Object)("Processing a ZipEntry " + zname));
                if (!zipEntry.isDirectory()) {
                    ByteArrayOutputStream byteArrayOutputStream;
                    String subsetDirspec = this.getSubmissionSetDirspec(zipEntry.getName());
                    if (this.matchName(zname, subsetDirspec, XDM_FILENAME_METADATA)) {
                        byteArrayOutputStream = this.readData(zipFile, zipEntry);
                        SubmitObjectsRequest submitObjectRequest = (SubmitObjectsRequest)XmlUtils.unmarshal(byteArrayOutputStream.toString(), ObjectFactory.class);
                        prsr.setSubmitObjectsRequest(submitObjectRequest);
                        docId = this.getDocId(submitObjectRequest);
                    } else if (this.matchName(zname, subsetDirspec, XDM_FILENAME_DATA)) {
                        byteArrayOutputStream = this.readData(zipFile, zipEntry);
                        ByteArrayDataSource source = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), (Object)((Object)MimeType.APPLICATION_XML) + "; charset=UTF-8");
                        DataHandler dhnew = new DataHandler((DataSource)source);
                        ProvideAndRegisterDocumentSetRequestType.Document pdoc = new ProvideAndRegisterDocumentSetRequestType.Document();
                        pdoc.setValue(dhnew);
                        pdoc.setId(docId);
                        List<ProvideAndRegisterDocumentSetRequestType.Document> docs = prsr.getDocument();
                        docs.add(pdoc);
                    }
                }
                if (prsr.getDocument().isEmpty()) continue;
                prsr.getDocument().get(0).setId(zname);
            }
            zipFile.close();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Unable to complete transformation.", (Throwable)e);
            }
            throw new TransformationException("Unable to complete transformation.", e);
        }
        return prsr;
    }

    public String getDocName(File file) throws TransformationException {
        LOGGER.trace((Object)"Begin transformation of XDM to XDS (file)");
        ZipFile zipFile = null;
        String objectId = null;
        ProvideAndRegisterDocumentSetRequestType prsr = new ProvideAndRegisterDocumentSetRequestType();
        try {
            zipFile = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            ZipEntry zipEntry = null;
            while (zipEntries.hasMoreElements()) {
                String subsetDirspec;
                zipEntry = zipEntries.nextElement();
                String zname = zipEntry.getName();
                LOGGER.trace((Object)("Processing a ZipEntry " + zname));
                if (zipEntry.isDirectory() || !this.matchName(zname, subsetDirspec = this.getSubmissionSetDirspec(zipEntry.getName()), XDM_FILENAME_METADATA)) continue;
                ByteArrayOutputStream byteArrayOutputStream = this.readData(zipFile, zipEntry);
                SubmitObjectsRequest submitObjectRequest = (SubmitObjectsRequest)XmlUtils.unmarshal(byteArrayOutputStream.toString(), ObjectFactory.class);
                prsr.setSubmitObjectsRequest(submitObjectRequest);
                objectId = this.getDocName(submitObjectRequest);
            }
            zipFile.close();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Unable to complete getObjectId.", (Throwable)e);
            }
            throw new TransformationException("Unable to complete getObjectId.", e);
        }
        return objectId;
    }

    @Override
    public ProvideAndRegisterDocumentSetRequestType transform(DataHandler dataHandler) throws TransformationException {
        LOGGER.trace((Object)"Begin transformation of XDM to XDS (datahandler)");
        File file = null;
        try {
            file = this.fileFromDataHandler(dataHandler);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Error creating temporary work file, unable to complete transformation.", (Throwable)e);
            }
            throw new TransformationException("Error creating temporary work file, unable to complete transformation.", e);
        }
        ProvideAndRegisterDocumentSetRequestType request = this.transform(file);
        boolean delete = file.delete();
        if (delete) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Deleted temporary work file " + file.getAbsolutePath()));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("Unable to delete temporary work file " + file.getAbsolutePath()));
        }
        return request;
    }

    protected String getDocId(SubmitObjectsRequest submitObjectRequest) {
        if (submitObjectRequest == null) {
            throw new IllegalArgumentException("SubmitObjectRequest must not be null.");
        }
        String ret = null;
        RegistryObjectListType rol = submitObjectRequest.getRegistryObjectList();
        List<JAXBElement<? extends IdentifiableType>> extensible = rol.getIdentifiable();
        for (JAXBElement<? extends IdentifiableType> elem : extensible) {
            String type = elem.getDeclaredType().getName();
            Object value = elem.getValue();
            if (StringUtils.equals((String)type, (String)"oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType")) {
                ret = this.getDocId((ExtrinsicObjectType)value);
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace((Object)(type + " " + value.toString()));
        }
        return ret;
    }

    protected String getDocName(SubmitObjectsRequest submitObjectRequest) {
        if (submitObjectRequest == null) {
            throw new IllegalArgumentException("SubmitObjectRequest must not be null.");
        }
        String ret = null;
        RegistryObjectListType rol = submitObjectRequest.getRegistryObjectList();
        List<JAXBElement<? extends IdentifiableType>> extensible = rol.getIdentifiable();
        for (JAXBElement<? extends IdentifiableType> elem : extensible) {
            String type = elem.getDeclaredType().getName();
            Object value = elem.getValue();
            if (!StringUtils.equals((String)type, (String)"oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType")) continue;
            String obId = ((ExtrinsicObjectType)value).getId();
            String mimeType = ((ExtrinsicObjectType)value).getMimeType();
            String suffix = "xml";
            if (mimeType.indexOf("xml") >= 0) {
                suffix = "xml";
            } else if (mimeType.indexOf("pdf") >= 0) {
                suffix = "pdf";
            }
            ret = obId + "." + suffix;
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace((Object)(type + " " + value.toString()));
        }
        return ret;
    }

    protected String getDocId(ExtrinsicObjectType extrinsicObjectType) {
        if (extrinsicObjectType == null) {
            throw new IllegalArgumentException("ExtrinsicObjectType must not be null");
        }
        String ret = null;
        for (ExternalIdentifierType eit : extrinsicObjectType.getExternalIdentifier()) {
            if (!StringUtils.equals((String)eit.getIdentificationScheme(), (String)"urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab")) continue;
            ret = eit.getValue();
        }
        return ret;
    }

    protected String getSubmissionSetDirspec(String zipEntryName) {
        if (zipEntryName == null) {
            return null;
        }
        String ret = "";
        zipEntryName = zipEntryName.replaceAll("\\\\", "/");
        String[] components = zipEntryName.split("/");
        for (int i = 0; i < components.length - 1; ++i) {
            ret = ret + components[i] + "/";
        }
        if (ret.length() == 0) {
            return "";
        }
        ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    protected boolean matchName(String zname, String subsetDirspec, String subsetFilespec) {
        zname = zname.replaceAll("\\\\", "/");
        String zipFilespec = subsetDirspec + "/" + subsetFilespec;
        boolean ret = StringUtils.equals((String)zname, (String)zipFilespec);
        return ret;
    }

    protected ByteArrayOutputStream readData(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream in = zipFile.getInputStream(zipEntry);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        while ((bytesRead = in.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        in.close();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Data read: " + baos.toString()));
        }
        return baos;
    }

    protected File fileFromDataHandler(DataHandler dh) throws Exception {
        File f = null;
        OutputStream out = null;
        InputStream inputStream = null;
        String fileName = "xdmail-" + UUID.randomUUID().toString() + ".zip";
        try {
            int len;
            f = new File(fileName);
            inputStream = dh.getInputStream();
            out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("File not found - " + fileName), (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Exception thrown while trying to read file from DataHandler object", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Created temporary work file " + f.getAbsolutePath()));
        }
        return f;
    }
}

