/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.boot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.RESTServiceDNSStore;
import org.nhindirect.dns.service.DNSServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan(value={"org.nhindirect.dns"})
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@SpringBootApplication
public class DNSServerApplication
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RESTServiceDNSStore.class);
    @Autowired
    protected DNSServerService dnsService;
    @Autowired
    protected DNSServerSettings settings;
    private static final String MODE_STANDALONE = "STANDALONE";
    private static final String MODE_SERVER = "SERVER";
    private static String mode;

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{DNSServerApplication.class}).web(WebApplicationType.NONE).build();
        springApplication.run(args);
    }

    public void run(String ... args) throws Exception {
        this.startAndRun();
    }

    private void startAndRun() {
        StringBuffer buffer = new StringBuffer("Starting DNS server.  Settings:");
        buffer.append("\r\n\tBind Addresses: ").append(this.settings.getBindAddress());
        buffer.append("\r\n\tListen Port: ").append(this.settings.getPort());
        LOGGER.info(buffer.toString() + "\n");
        try {
            this.dnsService.startServer();
        }
        catch (DNSException e) {
            LOGGER.error("Server failed to start: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (mode.equalsIgnoreCase(MODE_STANDALONE)) {
            LOGGER.info("\r\nServer running....  Press Enter or Return to stop.");
            InputStreamReader input = new InputStreamReader(System.in);
            BufferedReader reader = new BufferedReader(input);
            try {
                reader.readLine();
                LOGGER.info("Shutting down server.  Wait 5 seconds for cleanup.");
                this.dnsService.stopService();
                Thread.sleep(5000L);
                LOGGER.info("Server stopped");
            }
            catch (Exception exception) {}
        } else {
            LOGGER.info("\r\nServer running.");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        mode = MODE_SERVER;
    }
}

