/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.net.Inet4Address;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.ProxyDNSStore;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;

public class DNSConnectionTest
extends TestCase {
    public void testDNSSocketConnectionTCPWithProxyStore() throws Exception {
        DNSServerSettings settings = new DNSServerSettings();
        settings.setPort(AvailablePortFinder.getNextAvailable((int)1024));
        DNSServer server = new DNSServer((DNSStore)new ProxyDNSStore(), settings);
        server.start();
        Thread.currentThread();
        Thread.sleep(2000L);
        Options.set((String)"verbose", (String)"true");
        Lookup lu = new Lookup(new Name("google.com"), 1);
        Inet4Address.getLocalHost();
        ExtendedResolver resolver = new ExtendedResolver(new String[]{"127.0.0.1", Inet4Address.getLocalHost().getHostAddress()});
        resolver.setTCP(true);
        resolver.setPort(settings.getPort());
        lu.setResolver((Resolver)resolver);
        Record[] retRecords = lu.run();
        DNSConnectionTest.assertNotNull((Object)retRecords);
        server.stop();
        Thread.currentThread();
        Thread.sleep(4000L);
    }

    public void testDNSSocketConnectionUDPWithProxyStore() throws Exception {
        DNSServerSettings settings = new DNSServerSettings();
        settings.setPort(AvailablePortFinder.getNextAvailable((int)1024));
        DNSServer server = new DNSServer((DNSStore)new ProxyDNSStore(), settings);
        server.start();
        Thread.currentThread();
        Thread.sleep(2000L);
        Options.set((String)"verbose", (String)"true");
        Lookup lu = new Lookup(new Name("google.com"), 1);
        Inet4Address.getLocalHost();
        ExtendedResolver resolver = new ExtendedResolver(new String[]{"127.0.0.1", Inet4Address.getLocalHost().getHostAddress()});
        resolver.setTCP(false);
        resolver.setPort(settings.getPort());
        lu.setResolver((Resolver)resolver);
        Record[] retRecords = lu.run();
        DNSConnectionTest.assertNotNull((Object)retRecords);
        server.stop();
        Thread.currentThread();
        Thread.sleep(4000L);
    }
}

