/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSManager;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;

public class DNSManager_functional_Test
extends TestCase {
    public void testAddAName_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_aname_add", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(1);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                ARecord aRec = (ARecord)this.toRecord(rec);
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testAddDupAName_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_aname_add", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                command = new String[]{"dns_aname_add", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(1);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                ARecord aRec = (ARecord)this.toRecord(rec);
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testAddANameEnsure_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_aname_ensure", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(1);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                ARecord aRec = (ARecord)this.toRecord(rec);
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testDupANameEnsure_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_aname_ensure", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                command = new String[]{"dns_aname_ensure", "example.domain.com", "127.0.0.1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(1);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                ARecord aRec = (ARecord)this.toRecord(rec);
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testAddSOA_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_soa_add", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(6);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)6, (int)rec.getType());
                SOARecord soaRec = (SOARecord)this.toRecord(rec);
                Assert.assertEquals((String)soaRec.getAdmin().toString(), (String)"gm2552\\@example.com.");
                Assert.assertEquals((int)soaRec.getDClass(), (int)1);
                Assert.assertEquals((String)soaRec.getHost().toString(), (String)"ns1.example.com.");
                Assert.assertEquals((String)soaRec.getName().toString(), (String)"example.com.");
                Assert.assertEquals((long)soaRec.getTTL(), (long)3600L);
                Assert.assertEquals((long)soaRec.getSerial(), (long)1L);
            }
        }.perform();
    }

    public void testAddDupSOA_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_soa_add", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                command = new String[]{"dns_soa_add", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(6);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)6, (int)rec.getType());
                SOARecord soaRec = (SOARecord)this.toRecord(rec);
                Assert.assertEquals((String)soaRec.getAdmin().toString(), (String)"gm2552\\@example.com.");
                Assert.assertEquals((int)soaRec.getDClass(), (int)1);
                Assert.assertEquals((String)soaRec.getHost().toString(), (String)"ns1.example.com.");
                Assert.assertEquals((String)soaRec.getName().toString(), (String)"example.com.");
                Assert.assertEquals((long)soaRec.getTTL(), (long)3600L);
                Assert.assertEquals((long)soaRec.getSerial(), (long)1L);
            }
        }.perform();
    }

    public void testAddSOAEnsure_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_soa_ensure", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(6);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)6, (int)rec.getType());
                SOARecord soaRec = (SOARecord)this.toRecord(rec);
                Assert.assertEquals((String)soaRec.getAdmin().toString(), (String)"gm2552\\@example.com.");
                Assert.assertEquals((int)soaRec.getDClass(), (int)1);
                Assert.assertEquals((String)soaRec.getHost().toString(), (String)"ns1.example.com.");
                Assert.assertEquals((String)soaRec.getName().toString(), (String)"example.com.");
                Assert.assertEquals((long)soaRec.getTTL(), (long)3600L);
                Assert.assertEquals((long)soaRec.getSerial(), (long)1L);
            }
        }.perform();
    }

    public void testDupSOAEnsure_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_soa_ensure", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                command = new String[]{"dns_soa_ensure", "example.com", "ns1.example.com", "gm2552@example.com", "1", "3600"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(6);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"example.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)6, (int)rec.getType());
                SOARecord soaRec = (SOARecord)this.toRecord(rec);
                Assert.assertEquals((String)soaRec.getAdmin().toString(), (String)"gm2552\\@example.com.");
                Assert.assertEquals((int)soaRec.getDClass(), (int)1);
                Assert.assertEquals((String)soaRec.getHost().toString(), (String)"ns1.example.com.");
                Assert.assertEquals((String)soaRec.getName().toString(), (String)"example.com.");
                Assert.assertEquals((long)soaRec.getTTL(), (long)3600L);
                Assert.assertEquals((long)soaRec.getSerial(), (long)1L);
            }
        }.perform();
    }

    public void testAddMX_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_mx_add", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(15);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                MXRecord mxRec = (MXRecord)this.toRecord(rec);
                Assert.assertEquals((String)mxRec.getTarget().toString(), (String)"mail1.domain.com.");
            }
        }.perform();
    }

    public void testAddDupMX_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_mx_add", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                command = new String[]{"dns_mx_add", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(15);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                MXRecord mxRec = (MXRecord)this.toRecord(rec);
                Assert.assertEquals((String)mxRec.getTarget().toString(), (String)"mail1.domain.com.");
            }
        }.perform();
    }

    public void testAddMXEnsure_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_mx_ensure", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(15);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                MXRecord mxRec = (MXRecord)this.toRecord(rec);
                Assert.assertEquals((String)mxRec.getTarget().toString(), (String)"mail1.domain.com.");
            }
        }.perform();
    }

    public void testDupMXEnsure_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_mx_ensure", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                command = new String[]{"dns_mx_ensure", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(15);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)1, (int)records.length);
                DnsRecord rec = records[0];
                Assert.assertEquals((String)"domain.com.", (String)rec.getName());
                Assert.assertEquals((long)3600L, (long)rec.getTtl());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDclass());
                MXRecord mxRec = (MXRecord)this.toRecord(rec);
                Assert.assertEquals((String)mxRec.getTarget().toString(), (String)"mail1.domain.com.");
            }
        }.perform();
    }

    public void testGetAll_AssertAllRecords() throws Exception {
        new TestPlan(){

            @Override
            protected Collection<String[]> getCommands() throws Exception {
                ArrayList<String[]> commands = new ArrayList<String[]>();
                String[] command = new String[]{"dns_mx_ensure", "domain.com", "mail1.domain.com", "3600", "1"};
                commands.add(command);
                command = new String[]{"dns_soa_ensure", "domain.com", "ns1.domain.com", "gm2552@domain.com", "1", "3600"};
                commands.add(command);
                command = new String[]{"dns_aname_ensure", "ns1.domain.com", "10.45.110.23", "3600"};
                commands.add(command);
                command = new String[]{"dns_get_all"};
                commands.add(command);
                return commands;
            }

            @Override
            protected void doAssertions() throws Exception {
                DnsRecord[] records = this.proxy.getDNSByType(255);
                Assert.assertNotNull((Object)records);
                Assert.assertEquals((int)3, (int)records.length);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected static final int ERROR_FUNCTION_FAILED = 30839;
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
            DNSManager.setExitOnEndCommands((boolean)false);
        }

        @Override
        protected void performInner() throws Exception {
            Collection<String[]> commands = this.getCommands();
            for (String[] commandSet : commands) {
                String[] args = new String[commandSet.length + 2];
                args[0] = "configurl";
                args[1] = ConfigServiceRunner.getConfigServiceURL();
                System.arraycopy(commandSet, 0, args, 2, commandSet.length);
                DNSManager.main((String[])args);
            }
            this.doAssertions();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
            Certificate[] certs = this.proxy.getCertificatesForOwner(null, null);
            if (certs != null && certs.length > 0) {
                long[] ids = new long[certs.length];
                int cnt = 0;
                for (Certificate cert : certs) {
                    ids[cnt++] = cert.getId();
                }
                this.proxy.removeCertificates(ids);
            }
            certs = this.proxy.getCertificatesForOwner("", null);
            Assert.assertNull((Object)certs);
        }

        protected abstract Collection<String[]> getCommands() throws Exception;

        protected abstract void doAssertions() throws Exception;
    }
}

