/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.nhindirect.config.store.CertificateException;

public class Thumbprint {
    private final byte[] digest;
    private final String digestString;

    public static Thumbprint toThumbprint(X509Certificate cert) throws CertificateException {
        Thumbprint retVal = null;
        if (cert == null) {
            throw new IllegalArgumentException();
        }
        try {
            retVal = new Thumbprint(cert);
        }
        catch (Throwable e) {
            throw new CertificateException(e);
        }
        return retVal;
    }

    private Thumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        this.digest = md.digest();
        this.digestString = this.createStringRep();
    }

    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    private String createStringRep() {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(this.digest.length * 2);
        for (byte bt : this.digest) {
            buf.append(hexDigits[(bt & 0xF0) >> 4]);
            buf.append(hexDigits[bt & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.digestString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Thumbprint)) {
            return false;
        }
        Thumbprint compareTo = (Thumbprint)obj;
        return Arrays.equals(compareTo.digest, this.digest);
    }
}

