/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.annotation.ConfigServiceURL;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class ConfigServiceDNSStore
implements DNSStore {
    private static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    private static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.dns.JCEProviderName";
    private static final Log LOGGER = LogFactory.getFactory().getInstance(ConfigServiceDNSStore.class);
    private Map<String, Record> soaRecords = null;
    final ConfigurationServiceProxy proxy;

    public static String getJCEProviderName() {
        String retVal = System.getProperty(JCE_PROVIDER_STRING_SYS_PARAM);
        if (retVal == null || retVal.isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        if (name == null || name.isEmpty()) {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, DEFAULT_JCE_PROVIDER_STRING);
        } else {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, name);
        }
    }

    @Inject
    public ConfigServiceDNSStore(@ConfigServiceURL URL serviceURL) {
        this.proxy = new ConfigurationServiceProxy(serviceURL.toString());
    }

    @Override
    public Message get(Message request) throws DNSException {
        LOGGER.trace((Object)"get(Message) Entered");
        if (request == null) {
            throw new DNSException(DNSError.newError(1));
        }
        Header header = request.getHeader();
        if (header.getFlag(0) || header.getRcode() != 0) {
            throw new DNSException(DNSError.newError(1));
        }
        if (header.getOpcode() != 0) {
            throw new DNSException(DNSError.newError(4));
        }
        Record question = request.getQuestion();
        if (question == null || question.getDClass() != 1) {
            throw new DNSException(DNSError.newError(4));
        }
        Record queryRecord = request.getQuestion();
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Recieved Query Request:");
            builder.append("\r\n\tName: " + name.toString());
            builder.append("\r\n\tType: " + type);
            builder.append("\r\n\tDClass: " + queryRecord.getDClass());
            LOGGER.debug((Object)builder.toString());
        }
        RRset lookupRecords = null;
        switch (question.getType()) {
            case 1: 
            case 6: 
            case 15: 
            case 33: {
                try {
                    lookupRecords = this.processGenericRecordRequest(name.toString(), type);
                    break;
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call failed: " + e.getMessage(), e);
                }
            }
            case 37: {
                lookupRecords = this.processCERTRecordRequest(name.toString());
                break;
            }
            case 255: {
                RRset genRecs = this.processGenericRecordRequest(name.toString(), 255);
                RRset certRecs = this.processCERTRecordRequest(name.toString());
                if (genRecs == null || certRecs == null) {
                    if (genRecs != null) {
                        lookupRecords = genRecs;
                        break;
                    }
                    if (certRecs == null) break;
                    lookupRecords = certRecs;
                    break;
                }
                lookupRecords = genRecs;
                Iterator iter = certRecs.rrs();
                while (iter.hasNext()) {
                    lookupRecords.addRR((Record)iter.next());
                }
                break;
            }
            default: {
                LOGGER.debug((Object)("Query Type " + type + " not implemented"));
                throw new DNSException(DNSError.newError(4), "Query Type " + type + " not implemented");
            }
        }
        LOGGER.debug((Object)"No records found.");
        if (lookupRecords == null || lookupRecords.size() == 0) {
            return null;
        }
        Message response = new Message(request.getHeader().getID());
        response.getHeader().setFlag(0);
        if (request.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Iterator iter = lookupRecords.rrs();
        while (iter.hasNext()) {
            response.addRecord((Record)iter.next(), 1);
        }
        response.getHeader().setFlag(5);
        Record soaRecord = this.checkForSoaRecord(name.toString());
        if (soaRecord != null) {
            response.addRecord(soaRecord, 2);
        }
        LOGGER.trace((Object)"get(Message) Exit");
        return response;
    }

    protected RRset processGenericRecordRequest(String name, int type) throws DNSException {
        DnsRecord[] records;
        try {
            records = this.proxy.getDNSByNameAndType(name, type);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for DNS records failed: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            return null;
        }
        RRset retVal = new RRset();
        try {
            for (DnsRecord record : records) {
                Record rec = Record.newRecord((Name)Name.fromString((String)record.getName()), (int)record.getType(), (int)record.getDclass(), (long)record.getTtl(), (byte[])record.getData());
                retVal.addRR(rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing generic record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    protected RRset processCERTRecordRequest(String name) throws DNSException {
        Certificate[] certs;
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        try {
            certs = this.proxy.getCertificatesForOwner(name, null);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
        }
        if (certs == null || certs.length == 0) {
            int previousIndex = 0;
            int replaceIndex = 0;
            while ((replaceIndex = name.indexOf(".", previousIndex)) > -1) {
                char[] chars = name.toCharArray();
                chars[replaceIndex] = 64;
                try {
                    certs = this.proxy.getCertificatesForOwner(String.copyValueOf(chars), null);
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
                }
                if (certs != null && certs.length > 0 || replaceIndex >= name.length() - 1) break;
                previousIndex = replaceIndex + 1;
            }
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        RRset retVal = new RRset();
        try {
            for (Certificate cert : certs) {
                X509Certificate xCert = this.dataToCert(cert.getData());
                int keyTag = 0;
                if (xCert.getPublicKey() instanceof RSAKey) {
                    RSAKey key = (RSAKey)((Object)xCert.getPublicKey());
                    byte[] modulus = key.getModulus().toByteArray();
                    keyTag = modulus[modulus.length - 2] << 8 & 0xFF00;
                    keyTag |= modulus[modulus.length - 1] & 0xFF;
                }
                CERTRecord rec = new CERTRecord(Name.fromString((String)name), 1, 86400L, 1, keyTag, 5, xCert.getEncoded());
                retVal.addRR((Record)rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing CERT record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate dataToCert(byte[] data) throws DNSException {
        ByteArrayInputStream bais = null;
        X509Certificate retVal = null;
        try {
            bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", ConfigServiceDNSStore.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    retVal = (X509Certificate)localKeyStore.getCertificate(alias);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (bais != null) {
                    try {
                        bais.close();
                        bais = null;
                    }
                    catch (IOException e) {}
                }
            }
            if (retVal == null) {
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
        }
        catch (Exception e) {
            throw new DNSException("Data cannot be converted to a valid X.509 Certificate");
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
        return retVal;
    }

    private synchronized Record checkForSoaRecord(String questionName) {
        Record retVal;
        block8: {
            if (!questionName.endsWith(".")) {
                questionName = questionName + ".";
            }
            if (this.soaRecords == null) {
                DnsRecord[] getRecs = null;
                try {
                    getRecs = this.proxy.getDNSByType(6);
                    if (getRecs == null || getRecs.length == 0) {
                        this.soaRecords = Collections.emptyMap();
                    } else {
                        this.soaRecords = new HashMap<String, Record>();
                        for (DnsRecord rec : getRecs) {
                            Record newRec = Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)6, (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
                            this.soaRecords.put(newRec.getName().toString(), newRec);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Failed to load SOA records from config service.");
                }
            }
            retVal = null;
            if (this.soaRecords.size() <= 0 || (retVal = this.soaRecords.get(questionName)) != null) break block8;
            int index = -1;
            while ((index = questionName.indexOf(".")) > 0 && index < questionName.length() - 1 && (retVal = this.soaRecords.get(questionName = questionName.substring(index + 1))) == null) {
            }
        }
        return retVal;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

