/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSSocketServer;
import org.xbill.DNS.Message;

public class TCPServer
extends DNSSocketServer {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TCPServer.class);
    private ServerSocket serverSocket;

    public TCPServer(DNSServerSettings settings, DNSResponder responder) throws DNSException {
        super(settings, responder);
    }

    @Override
    public void start() throws DNSException {
        LOGGER.info((Object)"DNS TCP Server Starting");
        super.start();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("DNS TCP Server Startup Complete\r\n\tBind Address: ").append(this.settings.getBindAddress());
            builder.append("\r\n\tBind Port: ").append(this.settings.getPort());
            LOGGER.info((Object)builder.toString());
        }
    }

    @Override
    public void stop() throws DNSException {
        super.stop();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void createServerSocket() throws DNSException {
        try {
            this.serverSocket = new ServerSocket(this.settings.getPort(), this.settings.getMaxConnectionBacklog(), Inet4Address.getByName(this.settings.getBindAddress()));
        }
        catch (Exception e) {
            throw new DNSException(null, "Failed to create TCP server socket: " + e.getMessage(), e);
        }
    }

    @Override
    public Runnable getSocketAcceptTask() {
        return new AcceptTask();
    }

    @Override
    public Runnable getDNSRequestTask(Object s) {
        return new RequestTask((Socket)s);
    }

    private void reconnect() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.serverSocket = null;
        while (this.serverSocket == null && this.running) {
            try {
                this.createServerSocket();
                LOGGER.error((Object)"DNS TCP server socket re-established");
            }
            catch (DNSException ex) {
                LOGGER.error((Object)"DNS TCP server socket failed to rebind.  Trying again in 5 seconds.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class RequestTask
    implements Runnable {
        private Socket requestSocket;

        public RequestTask(Socket s) {
            this.requestSocket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message response = null;
            Message query = null;
            try {
                block13: {
                    InputStream is = this.requestSocket.getInputStream();
                    DataInputStream dataIn = new DataInputStream(is);
                    int inLength = dataIn.readUnsignedShort();
                    byte[] in = new byte[inLength];
                    dataIn.readFully(in);
                    try {
                        query = TCPServer.this.responder.toMessage(in);
                        response = TCPServer.this.responder.processRequest(query);
                    }
                    catch (DNSException e) {
                        if (query == null) break block13;
                        response = TCPServer.this.responder.processError(query, e.getError());
                    }
                }
                DataOutputStream dataOut = new DataOutputStream(this.requestSocket.getOutputStream());
                byte[] writeBytes = response.toWire();
                dataOut.writeShort(writeBytes.length);
                dataOut.write(writeBytes);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Wire/connection protocol error handing DNS request: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.requestSocket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class AcceptTask
    implements Runnable {
        private AcceptTask() {
        }

        @Override
        public void run() {
            while (TCPServer.this.running) {
                try {
                    Socket s = TCPServer.this.serverSocket.accept();
                    s.setReceiveBufferSize(TCPServer.this.settings.getMaxRequestSize());
                    s.setSoTimeout(TCPServer.this.settings.getReceiveTimeout());
                    TCPServer.this.submitDNSRequest(s);
                }
                catch (IOException e) {
                    if (!TCPServer.this.running) continue;
                    LOGGER.error((Object)("DNS TCP server socket dropped:" + e.getMessage()));
                    TCPServer.this.reconnect();
                }
            }
        }
    }
}

