/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.service;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerFactory;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.TCPServer;
import org.nhindirect.dns.provider.BasicDNSServerSettingsProvider;

public class DNSServerService {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TCPServer.class);
    private final DNSServer server;

    public DNSServerService(URL configLocation, DNSServerSettings settings) throws DNSException {
        LOGGER.info((Object)("Creating the DNSServer using configuration location " + configLocation.toExternalForm()));
        BasicDNSServerSettingsProvider settingsProv = new BasicDNSServerSettingsProvider(settings.getBindAddress(), settings.getPort());
        this.server = DNSServerFactory.createDNSServer(configLocation, null, settingsProv);
        LOGGER.info((Object)"DNS Server created.  Starting server.");
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOGGER.info((Object)"Shutdown hook detected.  Intiate server shutdown.");
                    DNSServerService.this.stopService();
                }
                catch (DNSException dNSException) {
                    // empty catch block
                }
            }
        });
    }

    public synchronized void stopService() throws DNSException {
        if (this.server != null) {
            LOGGER.info((Object)"Shutting down DNS server.");
            this.server.stop();
        }
    }
}

