/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools.utils;

import java.util.ArrayList;
import java.util.Arrays;

public class StringArrayUtil {
    private static final char[] Whitespace = new char[]{' ', '\t', '\r', '\n'};
    private static final char[] Quotes = new char[]{'\"'};

    public static String getValueOrNull(String[] args, int indexAt) {
        if (indexAt < 0 || indexAt >= args.length) {
            return null;
        }
        return args[indexAt];
    }

    public static boolean isNullOrEmpty(String[] args) {
        return args == null || args.length == 0;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getRequiredValue(String[] args, int index) {
        String value = StringArrayUtil.getValueOrNull(args, index);
        if (StringArrayUtil.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Missing argument at position " + index);
        }
        return value;
    }

    public static String getOptionalValue(String[] args, int index, String defaultValue) {
        String value = StringArrayUtil.getValueOrNull(args, index);
        if (StringArrayUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    static int skipOver(String source, int startAt, char[] chars) {
        for (int i = startAt; i < source.length(); ++i) {
            if (Arrays.binarySearch(chars, source.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    static String[] parseAsCommandLine(String input) {
        int tokenStartAt;
        if (StringArrayUtil.isNullOrEmpty(input)) {
            return new String[0];
        }
        ArrayList<String> retVal = new ArrayList<String>();
        int index = 0;
        while (index < input.length() && (tokenStartAt = StringArrayUtil.skipOver(input, index, Whitespace)) >= 0) {
            int length;
            char[] delimiter;
            if (Arrays.binarySearch(Quotes, input.charAt(tokenStartAt)) >= 0) {
                ++tokenStartAt;
                delimiter = Quotes;
            } else {
                delimiter = Whitespace;
            }
            int tokenEndAt = StringArrayUtil.skipTo(input, tokenStartAt, delimiter);
            if (tokenEndAt < 0) {
                tokenEndAt = input.length();
            }
            if ((length = tokenEndAt - tokenStartAt) > 0) {
                retVal.add(input.substring(tokenStartAt, tokenEndAt));
            }
            index = tokenEndAt + 1;
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    static int skipTo(String source, int startAt, char[] chars) {
        int firstIndex = 36863;
        int foundIndex = -1;
        for (char ch : chars) {
            foundIndex = source.indexOf(ch, startAt);
            if (foundIndex <= -1 || foundIndex >= firstIndex) continue;
            firstIndex = foundIndex;
        }
        return firstIndex < 36863 ? firstIndex : -1;
    }

    static {
        Arrays.sort(Whitespace);
    }
}

