/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.dao.DNSDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DNSDaoImpl
implements DNSDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(DNSDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=false)
    public void add(Collection<DNSRecord> records) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"add() Enter");
        }
        try {
            if (records != null && records.size() > 0) {
                for (DNSRecord record : records) {
                    if (record.getType() == 255) {
                        throw new ConfigurationStoreException("Cannot add records with type ANY.");
                    }
                    Collection<DNSRecord> checkRecs = this.get(record.getName(), record.getType());
                    if (checkRecs.contains(record)) {
                        throw new ConfigurationStoreException("Record name " + record.getName() + " and type " + record.getType() + " already exists with same rdata.");
                    }
                    record.setCreateTime(Calendar.getInstance());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Persisting DNS record\r\n\tName: " + record.getName() + "\r\n\tType: " + record.getType()));
                    }
                    this.entityManager.persist((Object)record);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Flushing " + records.size() + " added records."));
                }
                this.entityManager.flush();
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"add() Exit");
            }
        }
    }

    @Override
    public int count() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"count() Enter");
        }
        Long result = (Long)this.entityManager.createQuery("select count(d) from DNSRecord d").getSingleResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)("count() Exit: " + result.intValue()));
        }
        return result.intValue();
    }

    @Override
    public Collection<DNSRecord> get(int type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(int) Enter");
        }
        List result = Collections.emptyList();
        Query select = null;
        if (type != 255) {
            select = this.entityManager.createQuery("SELECT d from DNSRecord d WHERE d.type = ?1");
            select.setParameter(1, (Object)type);
        } else {
            select = this.entityManager.createQuery("SELECT d from DNSRecord d");
        }
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof DNSRecord) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(int) Exit");
        }
        return result;
    }

    @Override
    public DNSRecord get(long recordId) {
        Collection<DNSRecord> recs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(long) Enter");
        }
        if ((recs = this.get(new long[]{recordId})) == null || recs.isEmpty()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(long) Exit");
        }
        return recs.iterator().next();
    }

    @Override
    public Collection<DNSRecord> get(long[] recordIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(long[]) Enter");
        }
        List result = Collections.emptyList();
        if (recordIds != null && recordIds.length > 0) {
            Query select = null;
            StringBuffer idList = new StringBuffer("(");
            for (long id : recordIds) {
                if (idList.length() > 1) {
                    idList.append(", ");
                }
                idList.append(id);
            }
            idList.append(")");
            String query = "SELECT d from DNSRecord d WHERE d.id IN " + idList.toString();
            select = this.entityManager.createQuery(query);
            List rs = select.getResultList();
            if (rs != null && rs.size() != 0 && rs.get(0) instanceof DNSRecord) {
                result = rs;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(long[]) Exit");
        }
        return result;
    }

    @Override
    public Collection<DNSRecord> get(String name, int type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(String, int) Enter");
        }
        List result = Collections.emptyList();
        Query select = null;
        if (type == 255) {
            select = this.entityManager.createQuery("SELECT d from DNSRecord d WHERE UPPER(d.name) = ?1");
            select.setParameter(1, (Object)name.toUpperCase(Locale.getDefault()));
        } else {
            select = this.entityManager.createQuery("SELECT d from DNSRecord d WHERE UPPER(d.name) = ?1 and d.type = ?2");
            select.setParameter(1, (Object)name.toUpperCase(Locale.getDefault()));
            select.setParameter(2, (Object)type);
        }
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof DNSRecord) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(String, int) Exit");
        }
        return result;
    }

    @Override
    public Collection<DNSRecord> get(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(String) Enter");
        }
        Collection<DNSRecord> retVal = this.get(name, 255);
        if (log.isDebugEnabled()) {
            log.debug((Object)"get(String) Exit");
        }
        return retVal;
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(Collection<DNSRecord> records) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(Collection<DNSRecord>) Enter");
        }
        if (records != null && records.size() > 0) {
            ArrayList<DNSRecord> toDelete = new ArrayList<DNSRecord>();
            for (DNSRecord record : records) {
                toDelete.addAll(this.get(record.getName(), record.getType()));
            }
            if (toDelete.size() > 0) {
                for (DNSRecord record : toDelete) {
                    this.entityManager.remove((Object)record);
                }
            }
            if (log.isDebugEnabled()) {
                if (toDelete.size() == 0) {
                    log.debug((Object)"No DNS records qualified for deletion.");
                } else {
                    log.debug((Object)(toDelete.size() + " DNS records deleted"));
                }
            }
            this.entityManager.flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(Collection<DNSRecord>) Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(long recordId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(long) Enter");
        }
        this.remove(new long[]{recordId});
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(long) Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(long[] recordIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(long[]) Enter");
        }
        if (recordIds != null && recordIds.length > 0) {
            StringBuffer ids = new StringBuffer("(");
            for (long id : recordIds) {
                if (ids.length() > 1) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            ids.append(")");
            String query = "DELETE FROM DNSRecord d WHERE d.id IN " + ids.toString();
            int count = 0;
            Query delete = this.entityManager.createQuery(query);
            count = delete.executeUpdate();
            if (log.isDebugEnabled()) {
                if (count == 0) {
                    log.debug((Object)"No DNS records qualified for deletion.");
                } else {
                    log.debug((Object)(count + " DNS records deleted"));
                }
            }
            this.entityManager.flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(long[]) Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=false)
    public void update(long id, DNSRecord record) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"remove(long id, DNSRecord record) Enter");
        }
        try {
            if (record.getType() == 255) {
                throw new ConfigurationStoreException("Record type for update cannot be ANY");
            }
            DNSRecord toUpdate = this.get(id);
            if (toUpdate == null) {
                throw new ConfigurationStoreException("Record with id " + id + " does not exist.");
            }
            toUpdate.setType(record.getType());
            toUpdate.setName(record.getName());
            toUpdate.setTtl(record.getTtl());
            toUpdate.setDclass(record.getDclass());
            toUpdate.setData(record.getData());
            this.entityManager.merge((Object)toUpdate);
            this.entityManager.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)"1 DNS record updated.");
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"remove(long id, DNSRecord record) Exit");
            }
        }
    }
}

