/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSResponder;
import org.nhindirect.dns.DNSServerSettings;

public abstract class DNSSocketServer {
    protected final DNSServerSettings settings;
    protected final DNSResponder responder;
    protected ExecutorService socketAcceptService;
    protected ThreadPoolExecutor dnsRequestService;
    protected boolean running = false;

    public DNSSocketServer(DNSServerSettings settings, DNSResponder responsder) throws DNSException {
        this.settings = settings;
        this.responder = responsder;
        this.createServerSocket();
    }

    public void start() throws DNSException {
        this.running = true;
        this.dnsRequestService = new ThreadPoolExecutor(0, this.settings.getMaxActiveRequests(), 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.socketAcceptService = Executors.newSingleThreadExecutor();
        this.socketAcceptService.execute(this.getSocketAcceptTask());
    }

    public void stop() throws DNSException {
        this.running = false;
        this.socketAcceptService.shutdown();
        this.dnsRequestService.shutdown();
    }

    public abstract void createServerSocket() throws DNSException;

    public abstract Runnable getSocketAcceptTask();

    public abstract Runnable getDNSRequestTask(Object var1);

    protected void submitDNSRequest(Object s) {
        if (this.dnsRequestService.getActiveCount() < this.settings.getMaxActiveRequests()) {
            this.dnsRequestService.execute(this.getDNSRequestTask(s));
        } else {
            try {
                if (s instanceof Socket) {
                    ((Socket)s).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

