/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.net.URL;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.annotation.ConfigServiceURL;
import org.nhindirect.dns.provider.BasicDNSServerSettingsProvider;

public class DNSServerModule
extends AbstractModule {
    private final URL configServiceURL;
    private final Provider<DNSStore> dnsStore;
    private final Provider<DNSServerSettings> settings;

    public static DNSServerModule create(URL configServiceURL) {
        if (configServiceURL == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        return new DNSServerModule(configServiceURL, null, null);
    }

    public static DNSServerModule create(Provider<DNSStore> dnsStore) {
        if (dnsStore == null) {
            throw new IllegalArgumentException("dnsStore cannot be null.");
        }
        return new DNSServerModule(null, dnsStore, new BasicDNSServerSettingsProvider());
    }

    public static DNSServerModule create(Provider<DNSStore> dnsStore, Provider<DNSServerSettings> settings) {
        if (dnsStore == null) {
            throw new IllegalArgumentException("dnsStore cannot be null.");
        }
        if (settings == null) {
            settings = new BasicDNSServerSettingsProvider();
        }
        return new DNSServerModule(null, dnsStore, settings);
    }

    private DNSServerModule(URL configServiceURL, Provider<DNSStore> dnsStore, Provider<DNSServerSettings> settings) {
        this.configServiceURL = configServiceURL;
        this.dnsStore = dnsStore;
        this.settings = settings;
    }

    protected void configure() {
        if (this.configServiceURL != null) {
            this.bind(URL.class).annotatedWith(ConfigServiceURL.class).toInstance((Object)this.configServiceURL);
        } else {
            this.bind(DNSStore.class).toProvider(this.dnsStore);
            this.bind(DNSServerSettings.class).toProvider(this.settings);
        }
    }
}

