/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhind.config.EntityStatus;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.CertCommands;
import org.nhindirect.dns.tools.CertRecordCounterPrinter;
import org.nhindirect.dns.tools.printers.RecordPrinter;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;

public class CertCommands_listCerts_Test
extends TestCase {
    public void testGetRecords_noCertsInStore_AssertNoRecordFetched() throws Exception {
        new TestPlan(){

            @Override
            protected List<Certificate> getCertRecsToAdd() throws Exception {
                ArrayList<Certificate> retCerts = new ArrayList<Certificate>();
                return retCerts;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)0, (int)this.recordPrinter.getRecordCount());
            }
        }.perform();
    }

    public void testGetRecords_singleCertInStore_AssertRecordFetched() throws Exception {
        new TestPlan(){

            @Override
            protected List<Certificate> getCertRecsToAdd() throws Exception {
                ArrayList<Certificate> retCerts = new ArrayList<Certificate>();
                Certificate cert = new Certificate();
                cert.setOwner("test.com");
                cert.setData("http://localhost/test.der".getBytes());
                cert.setStatus(EntityStatus.ENABLED);
                retCerts.add(cert);
                return retCerts;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.recordPrinter.getRecordCount());
                Collection<Certificate> printedRecords = this.recordPrinter.getPrintedRecords();
                Certificate cert = printedRecords.iterator().next();
                Assert.assertEquals((String)"test.com", (String)cert.getOwner());
            }
        }.perform();
    }

    public void testGetRecords_multipleCertInStore_AssertRecordFetched() throws Exception {
        new TestPlan(){

            @Override
            protected List<Certificate> getCertRecsToAdd() throws Exception {
                ArrayList<Certificate> retCerts = new ArrayList<Certificate>();
                Certificate cert = new Certificate();
                cert.setOwner("test1.com");
                cert.setData("http://localhost/test1.der".getBytes());
                cert.setStatus(EntityStatus.ENABLED);
                retCerts.add(cert);
                cert = new Certificate();
                cert.setOwner("test2.com");
                cert.setData("http://localhost/test2.der".getBytes());
                cert.setStatus(EntityStatus.ENABLED);
                retCerts.add(cert);
                return retCerts;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)2, (int)this.recordPrinter.getRecordCount());
                boolean test1Found = false;
                boolean test2Found = false;
                for (Certificate cert : this.recordPrinter.getPrintedRecords()) {
                    if (cert.getOwner().equals("test1.com")) {
                        test1Found = true;
                        continue;
                    }
                    if (!cert.getOwner().equals("test2.com")) continue;
                    test2Found = true;
                }
                Assert.assertTrue((boolean)test1Found);
                Assert.assertTrue((boolean)test2Found);
            }
        }.perform();
    }

    public void testGetRecords_invalidProxy_AssertNoRecordFetched() throws Exception {
        new TestPlan(){

            @Override
            protected void setupMocks() throws Exception {
                super.setupMocks();
                this.proxy = new ConfigurationServiceProxy("http://boGussite.cdm");
                this.certCommands.setConfigurationProxy(this.proxy);
            }

            @Override
            protected List<Certificate> getCertRecsToAdd() throws Exception {
                ArrayList<Certificate> retCerts = new ArrayList<Certificate>();
                return retCerts;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)0, (int)this.recordPrinter.getRecordCount());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected CertRecordCounterPrinter recordPrinter;
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected CertCommands certCommands;

        TestPlan() {
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
            this.recordPrinter = new CertRecordCounterPrinter();
            this.certCommands = new CertCommands(this.proxy);
            this.certCommands.setRecordPrinter((RecordPrinter)this.recordPrinter);
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
            Certificate[] certs = this.proxy.listCertificates(0L, 1000, null);
            if (certs != null && certs.length > 0) {
                long[] ids = new long[certs.length];
                int idx = 0;
                for (Certificate cert : certs) {
                    ids[idx++] = cert.getId();
                }
                this.proxy.removeCertificates(ids);
            }
        }

        @Override
        protected void performInner() throws Exception {
            List<Certificate> certsToAdd = this.getCertRecsToAdd();
            if (certsToAdd.size() > 0) {
                this.proxy.addCertificates(certsToAdd.toArray(new Certificate[certsToAdd.size()]));
            }
            this.certCommands.listCerts(new String[0]);
            this.doAssertions();
        }

        protected abstract List<Certificate> getCertRecsToAdd() throws Exception;

        protected abstract void doAssertions() throws Exception;
    }
}

