/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.FileUtils;
import org.nhind.config.DnsRecord;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;

public class DNSRecordUtil {
    private static final String certBasePath = "src/test/resources/certs/";

    private static DnsRecord toDnsRecord(DNSRecord rec) {
        DnsRecord retVal = new DnsRecord();
        retVal.setData(rec.getData());
        retVal.setDclass(rec.getDclass());
        retVal.setName(rec.getName());
        retVal.setTtl(rec.getTtl());
        retVal.setType(rec.getType());
        return retVal;
    }

    public static String getCertOwner(X509Certificate cert) {
        X500Principal prin = cert.getSubjectX500Principal();
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = prin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        String address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }

    public static X509Certificate loadCertificate(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        ByteArrayInputStream str = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)fl));
        X509Certificate retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(str);
        ((InputStream)str).close();
        return retVal;
    }

    public static DnsRecord createARecord(String name, String ip) throws Exception {
        DNSRecord rec = DNSRecordUtils.createARecord((String)name, (long)86400L, (String)ip);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DnsRecord createCERTRecord(String name, X509Certificate cert) throws Exception {
        DNSRecord rec = DNSRecordUtils.createX509CERTRecord((String)name, (long)86400L, (X509Certificate)cert);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DnsRecord createMXRecord(String name, String target, int priority) throws Exception {
        DNSRecord rec = DNSRecordUtils.createMXRecord((String)name, (String)target, (long)86400L, (int)priority);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DnsRecord createSOARecord(String name, String nameServer, String hostmaster) throws Exception {
        DNSRecord rec = DNSRecordUtils.createSOARecord((String)name, (long)3600L, (String)nameServer, (String)hostmaster, (int)1, (long)3600L, (long)600L, (long)604800L, (long)3600L);
        return DNSRecordUtil.toDnsRecord(rec);
    }

    public static DnsRecord createNSRecord(String name, String target) throws Exception {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        NSRecord rec = new NSRecord(Name.fromString((String)name), 1, 86400L, Name.fromString((String)target));
        return DNSRecordUtil.toDnsRecord(DNSRecord.fromWire((byte[])rec.toWireCanonical()));
    }

    public static DnsRecord createCNAMERecord(String name, String target) throws Exception {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        CNAMERecord rec = new CNAMERecord(Name.fromString((String)name), 1, 86400L, Name.fromString((String)target));
        return DNSRecordUtil.toDnsRecord(DNSRecord.fromWire((byte[])rec.toWireCanonical()));
    }
}

