/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.util.Arrays;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhindirect.dns.tools.CertCommands;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.tools.utils.Commands;

public class DNSManager {
    private static final String DEFAULT_CONFIG_URL = "http://localhost:8081/config-service/ConfigurationService";
    private final Commands commands;
    private static boolean exitOnEndCommands = true;

    public static void main(String[] args) {
        String[] passArgs = null;
        String configURL = null;
        if (args.length > 1 && args[0].equalsIgnoreCase("configurl")) {
            configURL = args[1];
            passArgs = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : new String[]{};
        }
        if (configURL == null) {
            configURL = DEFAULT_CONFIG_URL;
            passArgs = args;
        }
        DNSManager manager = null;
        try {
            manager = new DNSManager(new URL(configURL));
        }
        catch (Exception e) {
            System.err.println("Invalid config URL");
        }
        boolean runCommand = false;
        if (manager != null) {
            runCommand = manager.run(passArgs);
        }
        if (exitOnEndCommands) {
            System.exit(runCommand ? 0 : -1);
        }
    }

    public DNSManager(URL configURL) {
        ConfigurationServiceProxy proxy = new ConfigurationServiceProxy(configURL.toExternalForm());
        this.commands = new Commands("DNS Management Console");
        this.commands.register(new DNSRecordCommands(proxy));
        this.commands.register(new CertCommands(proxy));
        System.out.println("Configuration service URL: " + configURL.toExternalForm());
    }

    public boolean run(String[] args) {
        if (args != null && args.length > 0) {
            return this.commands.run(args);
        }
        this.commands.runInteractive();
        System.out.println("Shutting Down DNS Manager Console");
        return true;
    }

    public static void setExitOnEndCommands(boolean exit) {
        exitOnEndCommands = exit;
    }
}

