/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.util.Arrays;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.tools.DNSRecordParser;
import org.nhindirect.dns.tools.DNSRecordPrinter;
import org.nhindirect.dns.tools.DefaultDNSRecordPrinter;
import org.nhindirect.dns.tools.utils.Command;
import org.nhindirect.dns.tools.utils.StringArrayUtil;
import org.xbill.DNS.Record;

public class DNSRecordCommands {
    private static final String IMPORT_MX_USAGE = "Import a new MX dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the MX record binary file. Can have any (or no extension)";
    private static final String IMPORT_SOA_USAGE = "Import a new SOA dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the SOA record binary file. Can have any (or no extension)";
    private static final String IMPORT_ADDRESS_USAGE = "Import a new A dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the A record binary file. Can have any (or no extension)";
    private static final String ADD_MX_USAGE = "Add a new MX dns record.\r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record";
    private static final String ENSURE_MX_USAGE = "Adds a new MX dns record if an identical one does't already exist. \r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record";
    private static final String ADD_SOA_USAGE = "Add a new SOA dns record.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.";
    private static final String ENSURE_SOA_USAGE = "Add a new SOA dns record if an identical one does not exist.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.";
    private static final String ADD_ANAME_USAGE = "Add a new ANAME dns record.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int";
    private static final String ENSURE_ANAME_USAGE = "Add a new ANAME dns record if an identical one does not exist.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int";
    private static final String REMOVE_MX_USAGE = "Remove an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database";
    private static final String REMOVE_SOA_USAGE = "Remove an existing SOA record by ID.\r\n\trecordid\r\nt\t recordid: record id to be removed from the database";
    private static final String REMOVE_ANAME_USAGE = "Remove an existing ANAME record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database";
    private static final String GET_MX_USAGE = "Gets an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be retrieved from the database";
    private static final String GET_SOA_USAGE = "Gets an existing SOA record by ID.\r\n\trecordid\r\n\t recordid: record id to be retrieved from the database";
    private static final String GET_ANAME_USAGE = "Gets an existing ANAME record by ID.\r\n\trecordid";
    private static final String GET_ALL_USAGE = "Gets all records in the DNS store.";
    private DNSRecordPrinter printer;
    private DNSRecordParser parser = new DNSRecordParser();
    private ConfigurationServiceProxy proxy;

    public DNSRecordCommands(ConfigurationServiceProxy proxy) {
        this.printer = new DefaultDNSRecordPrinter();
        this.proxy = proxy;
    }

    private DnsRecord fromRecord(Record rec) {
        DnsRecord retVal = new DnsRecord();
        retVal.setData(rec.rdataToWireCanonical());
        retVal.setDclass(rec.getDClass());
        retVal.setName(rec.getName().toString());
        retVal.setTtl(rec.getTTL());
        retVal.setType(rec.getType());
        return retVal;
    }

    private DnsRecord loadAndVerifyDnsRecordFromBin(String path) {
        File recFile = new File(path);
        if (!recFile.exists()) {
            throw new IllegalArgumentException("Record file " + recFile.getAbsolutePath() + " not found");
        }
        Record rec = null;
        try {
            byte[] wire = FileUtils.readFileToByteArray((File)recFile);
            rec = Record.fromWire((byte[])wire, (int)1);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file " + recFile.getAbsolutePath() + " : " + e.getMessage(), e);
        }
        return rec != null ? this.fromRecord(rec) : null;
    }

    private void addDNS(DnsRecord dnsRecord) {
        try {
            this.proxy.addDNS(new DnsRecord[]{dnsRecord});
            System.out.println("Record added successfully.");
        }
        catch (RemoteException e) {
            throw new RuntimeException("Error adding DNS record: " + e.getMessage(), e);
        }
    }

    private void removeDNS(long recordId) {
        try {
            this.proxy.removeDNSByRecordId(recordId);
            System.out.println("Record removed successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
    }

    private void importRecord(String path, int type) {
        DnsRecord dnsRecord = this.loadAndVerifyDnsRecordFromBin(path);
        if (dnsRecord.getType() != type) {
            throw new IllegalArgumentException("File " + path + " does not contain the requested record type");
        }
        this.addDNS(dnsRecord);
    }

    @Command(name="Dns_MX_Import", usage="Import a new MX dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the MX record binary file. Can have any (or no extension)")
    public void mXImport(String[] args) {
        String path = StringArrayUtil.getRequiredValue(args, 0);
        this.importRecord(path, 15);
    }

    @Command(name="Dns_SOA_Import", usage="Import a new SOA dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the SOA record binary file. Can have any (or no extension)")
    public void sOAImport(String[] args) {
        String path = StringArrayUtil.getRequiredValue(args, 0);
        this.importRecord(path, 6);
    }

    @Command(name="Dns_ANAME_Import", usage="Import a new A dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the A record binary file. Can have any (or no extension)")
    public void importAddress(String[] args) {
        String path = StringArrayUtil.getRequiredValue(args, 0);
        this.importRecord(path, 1);
    }

    @Command(name="Dns_MX_Add", usage="Add a new MX dns record.\r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record")
    public void addMX(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseMX(args));
        this.addDNS(record);
    }

    @Command(name="Dns_MX_Ensure", usage="Adds a new MX dns record if an identical one does't already exist. \r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record")
    public void ensureMX(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseMX(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_SOA_Add", usage="Add a new SOA dns record.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.")
    public void addSOA(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseSOA(args));
        this.addDNS(record);
    }

    @Command(name="Dns_SOA_Ensure", usage="Add a new SOA dns record if an identical one does not exist.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.")
    public void ensureSOA(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseSOA(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_ANAME_Add", usage="Add a new ANAME dns record.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int")
    public void addANAME(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseANAME(args));
        this.addDNS(record);
    }

    @Command(name="Dns_ANAME_Ensure", usage="Add a new ANAME dns record if an identical one does not exist.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int")
    public void ensureANAME(String[] args) {
        DnsRecord record = this.fromRecord((Record)this.parser.parseANAME(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_MX_Remove", usage="Remove an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database")
    public void removeMX(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue(args, 0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_SOA_Remove", usage="Remove an existing SOA record by ID.\r\n\trecordid\r\nt\t recordid: record id to be removed from the database")
    public void removeSOA(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue(args, 0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_ANAME_Remove", usage="Remove an existing ANAME record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database")
    public void removeANAME(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue(args, 0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_MX_Get", usage="Gets an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be retrieved from the database")
    public void getMX(String[] args) {
        this.get(Long.parseLong(StringArrayUtil.getRequiredValue(args, 0)));
    }

    @Command(name="Dns_SOA_Get", usage="Gets an existing SOA record by ID.\r\n\trecordid\r\n\t recordid: record id to be retrieved from the database")
    public void getSOA(String[] args) {
        this.get(Long.parseLong(StringArrayUtil.getRequiredValue(args, 0)));
    }

    @Command(name="Dns_ANAME_Get", usage="Gets an existing ANAME record by ID.\r\n\trecordid")
    public void getANAME(String[] args) {
        this.get(Long.parseLong(StringArrayUtil.getRequiredValue(args, 0)));
    }

    @Command(name="Dns_Get_All", usage="Gets all records in the DNS store.")
    public void getAll(String[] args) {
        DnsRecord[] records = null;
        try {
            records = this.proxy.getDNSByType(255);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            System.out.println("No records found");
        } else {
            this.print(records);
        }
    }

    private void get(long recordID) {
        DnsRecord record = this.getRecord(recordID);
        if (record != null) {
            this.printer.print(record);
        }
    }

    @Command(name="Dns_Match", usage="Resolve all records for the given domain")
    public void match(String[] args) {
        String domain = StringArrayUtil.getRequiredValue(args, 0);
        DnsRecord[] records = null;
        Pattern pattern = Pattern.compile(domain);
        ArrayList<DnsRecord> matchedRecords = new ArrayList<DnsRecord>();
        try {
            records = this.proxy.getDNSByType(255);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            System.out.println("No records found");
            return;
        }
        for (DnsRecord record : records) {
            Matcher matcher = pattern.matcher(record.getName());
            if (!matcher.find()) continue;
            matchedRecords.add(record);
        }
        if (matchedRecords.size() == 0) {
            System.out.println("No records found");
            return;
        }
        this.print(matchedRecords.toArray(new DnsRecord[matchedRecords.size()]));
    }

    @Command(name="Dns_SOA_Match", usage="Resolve SOA records for the given domain")
    public void matchSOA(String[] args) {
        this.match(StringArrayUtil.getRequiredValue(args, 0), 6);
    }

    @Command(name="Dns_ANAME_Match", usage="Resolve Address records for the given domain")
    public void matchAName(String[] args) {
        this.match(StringArrayUtil.getRequiredValue(args, 0), 1);
    }

    @Command(name="Dns_MX_Match", usage="Resolve MX records for the given domain")
    public void matchMX(String[] args) {
        this.match(StringArrayUtil.getRequiredValue(args, 0), 15);
    }

    private void match(String domain, int type) {
        DnsRecord[] records = this.getRecords(domain, type);
        if (records != null && records.length > 0) {
            this.print(records);
        }
    }

    private DnsRecord getRecord(long recordID) {
        DnsRecord dr = null;
        try {
            dr = this.proxy.getDNSByRecordId(recordID);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (dr == null) {
            System.out.println("No record found matching id.");
        }
        return dr;
    }

    private DnsRecord[] getRecords(String domain, int type) {
        if (!domain.endsWith(".")) {
            domain = domain + ".";
        }
        DnsRecord[] records = null;
        try {
            records = this.proxy.getDNSByNameAndType(domain, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            System.out.println("No records found");
        }
        return records;
    }

    private boolean verifyIsUnique(DnsRecord record, boolean details) {
        DnsRecord existing = this.find(record);
        if (existing != null) {
            System.out.println("Record already exists");
            this.print(existing);
            return false;
        }
        return true;
    }

    private DnsRecord find(DnsRecord record) {
        DnsRecord[] existingRecords = null;
        try {
            existingRecords = this.proxy.getDNSByNameAndType(record.getName(), record.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (existingRecords == null || existingRecords.length == 0) {
            return null;
        }
        for (DnsRecord existingRecord : existingRecords) {
            if (!Arrays.areEqual((byte[])record.getData(), (byte[])existingRecord.getData())) continue;
            return existingRecord;
        }
        return null;
    }

    private void print(DnsRecord[] records) {
        if (records != null) {
            for (DnsRecord record : records) {
                this.print(record);
                System.out.println("\r\n-------------------------------------------");
            }
        }
    }

    private void print(DnsRecord dnsRecord) {
        System.out.println("RecordID: " + dnsRecord.getId());
        this.printer.print(dnsRecord);
    }

    public void setRecordPrinter(DNSRecordPrinter printer) {
        this.printer = printer;
    }

    public void setConfigurationProxy(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
    }
}

