/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.LdapCertUtil;
import org.nhindirect.stagent.cert.impl.LdapEnvironment;

public class LdapCertUtilImpl
implements LdapCertUtil {
    private LdapEnvironment ldapEnvironment;
    private String keyStorePassword;
    private String certificateFormat;

    public LdapCertUtilImpl(LdapEnvironment ldapEnvironment, String keyStorePassword, String certificateFormat) {
        this.ldapEnvironment = ldapEnvironment;
        this.keyStorePassword = keyStorePassword;
        this.certificateFormat = certificateFormat;
    }

    @Override
    public Collection<X509Certificate> ldapSearch(String subjectName) {
        InitialDirContext ctx = null;
        try {
            ctx = this.getInitialDirContext(this.ldapEnvironment.getEnv());
            SearchControls ctls = this.getDefaultSearchControls();
            NamingEnumeration<SearchResult> searchResult = ctx.search(this.ldapEnvironment.getLdapSearchBase(), this.ldapEnvironment.getLdapSearchAttribute() + "=" + subjectName, ctls);
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            while (searchResult != null && searchResult.hasMoreElements()) {
                Attribute certAttribute;
                Attributes certAttributes;
                SearchResult certEntry = (SearchResult)searchResult.nextElement();
                if (certEntry == null || (certAttributes = certEntry.getAttributes()) == null || (certAttribute = certAttributes.get(this.ldapEnvironment.getReturningCertAttribute())) == null) continue;
                NamingEnumeration<?> allValues = certAttribute.getAll();
                while (allValues.hasMoreElements()) {
                    String ksBytes = (String)allValues.nextElement();
                    Base64 base64 = new Base64();
                    byte[] decode = base64.decode(ksBytes.getBytes());
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(decode);
                    if (this.certificateFormat.equalsIgnoreCase("pkcs12")) {
                        try {
                            this.processPKCS12FileFormatAndAddToCertificates(inputStream, certificates);
                            continue;
                        }
                        catch (Exception e) {
                            this.closeDirContext(ctx);
                            throw new NHINDException((Object)e);
                        }
                    }
                    if (this.certificateFormat.equalsIgnoreCase("X.509") || this.certificateFormat.equalsIgnoreCase("X509")) {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509Certificate addCert = (X509Certificate)cf.generateCertificate(inputStream);
                        certificates.add(addCert);
                        continue;
                    }
                    this.closeDirContext(ctx);
                    throw new NHINDException("Invalid certificate format requested");
                }
            }
            return certificates;
        }
        catch (NamingException e) {
            this.closeDirContext(ctx);
            throw new NHINDException((Object)e);
        }
        catch (CertificateException e) {
            this.closeDirContext(ctx);
            throw new NHINDException((Object)e);
        }
    }

    protected void processPKCS12FileFormatAndAddToCertificates(ByteArrayInputStream inputStream, ArrayList<X509Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore localKeyStore = KeyStore.getInstance("PKCS12");
        localKeyStore.load(inputStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        IOUtils.closeQuietly((InputStream)inputStream);
        Enumeration<String> aliases = localKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            Key key;
            String alias = aliases.nextElement();
            Certificate cert = localKeyStore.getCertificate(alias);
            if (cert == null || !(cert instanceof X509Certificate) || (key = localKeyStore.getKey(alias, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray())) == null || !(key instanceof PrivateKey)) continue;
            X509CertificateEx addCert = X509CertificateEx.fromX509Certificate((X509Certificate)cert, (PrivateKey)key);
            certificates.add(addCert);
        }
    }

    protected SearchControls getDefaultSearchControls() {
        SearchControls ctls = new SearchControls();
        ctls.setReturningObjFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{this.ldapEnvironment.getReturningCertAttribute()});
        return ctls;
    }

    protected InitialDirContext getInitialDirContext(Hashtable<String, String> env) throws NamingException {
        return new InitialDirContext(env);
    }

    protected void closeDirContext(DirContext dirContext) {
        if (dirContext != null) {
            try {
                dirContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public LdapEnvironment getLdapEnvironment() {
        return this.ldapEnvironment;
    }
}

