/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.LocalVariableType;

public class LocalVariableTypeTableAttribute
extends Attribute {
    protected List types = new ArrayList();

    public LocalVariableTypeTableAttribute() {
        super("LocalVariableTypeTable");
    }

    public List getTypes() {
        return this.types;
    }

    protected Label[] getLabels() {
        HashSet<Label> hashSet = new HashSet<Label>();
        for (int i = 0; i < this.types.size(); ++i) {
            LocalVariableType localVariableType = (LocalVariableType)this.types.get(i);
            hashSet.add(localVariableType.getStart());
            hashSet.add(localVariableType.getEnd());
        }
        return hashSet.toArray(new Label[hashSet.size()]);
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        int n4 = classReader.readUnsignedShort(n);
        n += 2;
        LocalVariableTypeTableAttribute localVariableTypeTableAttribute = new LocalVariableTypeTableAttribute();
        for (int i = 0; i < n4; ++i) {
            LocalVariableType localVariableType = new LocalVariableType();
            int n5 = classReader.readUnsignedShort(n);
            int n6 = classReader.readUnsignedShort(n + 2);
            localVariableType.start = this.getLabel(labelArray, n5);
            localVariableType.end = this.getLabel(labelArray, n5 + n6);
            localVariableType.name = classReader.readUTF8(n + 4, cArray);
            localVariableType.signature = classReader.readUTF8(n + 6, cArray);
            localVariableType.index = classReader.readUnsignedShort(n + 8);
            n += 10;
            this.types.add(localVariableType);
        }
        return localVariableTypeTableAttribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            LocalVariableType localVariableType = (LocalVariableType)this.types.get(i);
            int n4 = localVariableType.getStart().getOffset();
            byteVector.putShort(n4);
            byteVector.putShort(localVariableType.getEnd().getOffset() - n4);
            byteVector.putUTF8(localVariableType.getName());
            byteVector.putUTF8(localVariableType.getSignature());
            byteVector.putShort(localVariableType.getIndex());
        }
        return byteVector;
    }

    private Label getLabel(Label[] labelArray, int n) {
        Label label = labelArray[n];
        if (label == null) {
            labelArray[n] = label = new Label();
        }
        return label;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LocalVariableTypeTable[");
        for (int i = 0; i < this.types.size(); ++i) {
            stringBuffer.append('\n').append('[').append(this.types.get(i)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

