@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\guice-2.0.jar;"%REPO%"\aopalliance-1.0.jar;"%REPO%"\commons-logging-1.1.1.jar;"%REPO%"\commons-io-1.4.jar;"%REPO%"\bcprov-jdk15-140.jar;"%REPO%"\dnsjava-2.0.8.jar;"%REPO%"\config-service-client-1.1.jar;"%REPO%"\axis-1.4.jar;"%REPO%"\commons-discovery-0.4.jar;"%REPO%"\jaxrpc-api-1.1.jar;"%REPO%"\saaj-api-1.3.jar;"%REPO%"\wsdl4j-1.6.2.jar;"%REPO%"\agent-1.5.3.jar;"%REPO%"\commons-codec-1.4.jar;"%REPO%"\apache-jsieve-mailet-0.4.jar;"%REPO%"\apache-jsieve-0.4.jar;"%REPO%"\apache-mailet-2.4.jar;"%REPO%"\apache-mailet-base-1.0.jar;"%REPO%"\apache-mime4j-0.6.jar;"%REPO%"\activation-1.1.jar;"%REPO%"\mail-1.4.5.jar;"%REPO%"\bcmail-jdk15-140.jar;"%REPO%"\jcs-1.3.jar;"%REPO%"\concurrent-1.0.jar;"%REPO%"\config-store-1.2.jar;"%REPO%"\spring-asm-3.0.4.RELEASE.jar;"%REPO%"\spring-core-3.0.4.RELEASE.jar;"%REPO%"\spring-aop-3.0.4.RELEASE.jar;"%REPO%"\spring-tx-3.0.4.RELEASE.jar;"%REPO%"\spring-orm-3.0.4.RELEASE.jar;"%REPO%"\spring-jdbc-3.0.4.RELEASE.jar;"%REPO%"\spring-test-3.0.4.RELEASE.jar;"%REPO%"\spring-beans-3.0.4.RELEASE.jar;"%REPO%"\spring-context-3.0.4.RELEASE.jar;"%REPO%"\spring-expression-3.0.4.RELEASE.jar;"%REPO%"\commons-collections-3.1.jar;"%REPO%"\commons-dbcp-1.4.jar;"%REPO%"\commons-pool-1.5.4.jar;"%REPO%"\jta-1.1.jar;"%REPO%"\ehcache-1.2.3.jar;"%REPO%"\asm-attrs-1.5.3.jar;"%REPO%"\dom4j-1.6.1.jar;"%REPO%"\antlr-2.7.6.jar;"%REPO%"\cglib-2.1_3.jar;"%REPO%"\asm-1.5.3.jar;"%REPO%"\hibernate-core-3.3.2.GA.jar;"%REPO%"\geronimo-jpa_2.0_spec-1.0.jar;"%REPO%"\hibernate-entitymanager-3.3.2.GA.jar;"%REPO%"\hibernate-3.2.6.ga.jar;"%REPO%"\hibernate-commons-annotations-3.0.0.ga.jar;"%REPO%"\javassist-3.4.GA.jar;"%REPO%"\hibernate-annotations-3.3.1.GA.jar;"%REPO%"\jaxb-api-2.1.jar;"%REPO%"\stax-api-1.0-2.jar;"%REPO%"\slf4j-api-1.2.jar;"%REPO%"\dns-1.2.2.jar
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog -Dorg.apache.commons.logging.simplelog.defaultlog=error -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="DNSMgmtConsole" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" org.nhindirect.dns.tools.DNSManager %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
