/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.service;

import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.service.DNSServerService;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;

public class DNSServerService_constructTest
extends TestCase {
    public void testConstructServer_assertDefaultDNSStore() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions() {
                Assert.assertEquals((String)"org.nhindirect.dns.ConfigServiceDNSStore", (String)this.server.server.getDNSStoreImplName());
            }
        }.perform();
    }

    public void testConstructServer_nonExistantProviderClass_assertDefaultDNSStore() throws Exception {
        new TestPlan(){

            @Override
            public void setupMocks() throws Exception {
                super.setupMocks();
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "com.cern.bogus.WhoCares");
            }

            @Override
            public void tearDownMocks() throws Exception {
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "");
                super.tearDownMocks();
            }

            @Override
            protected void doAssertions() {
                Assert.assertEquals((String)"org.nhindirect.dns.ConfigServiceDNSStore", (String)this.server.server.getDNSStoreImplName());
            }
        }.perform();
    }

    public void testConstructServer_overriddenProviderClass_assertDNSStoreClass() throws Exception {
        new TestPlan(){

            @Override
            public void setupMocks() throws Exception {
                super.setupMocks();
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "org.nhindirect.dns.provider.MockDNSStoreProvider");
            }

            @Override
            public void tearDownMocks() throws Exception {
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "");
                super.tearDownMocks();
            }

            @Override
            protected void doAssertions() {
                Assert.assertEquals((String)"org.nhindirect.dns.MockDNSStore", (String)this.server.server.getDNSStoreImplName());
            }
        }.perform();
    }

    public void testConstructServer_overriddenConfigDNSProviderClass_assertDNSStoreClass() throws Exception {
        new TestPlan(){

            @Override
            public void setupMocks() throws Exception {
                super.setupMocks();
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "org.nhindirect.dns.provider.MockConfigDNSStoreProvider");
            }

            @Override
            public void tearDownMocks() throws Exception {
                System.setProperty("org.nhindirect.dns.DNSStoreProviderClass", "");
                super.tearDownMocks();
            }

            @Override
            protected void doAssertions() {
                Assert.assertEquals((String)"org.nhindirect.dns.MockDNSStore", (String)this.server.server.getDNSStoreImplName());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServerService server = null;
        protected ConfigurationServiceProxy proxy;

        TestPlan() {
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stopService();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServerService(new URL(ConfigServiceRunner.getConfigServiceURL()), settings);
            this.doAssertions();
        }

        protected void doAssertions() {
        }
    }
}

