/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.axis.AxisFault;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DNSRecordCommands_ensureARecords_Test
extends TestCase {
    public void testEnsureAName_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                return addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = records.iterator().next();
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName().toString());
                Assert.assertEquals((long)3600L, (long)rec.getTTL());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDClass());
                ARecord aRec = (ARecord)rec;
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testEnsureAName_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                return addRecords;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = records.iterator().next();
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName().toString());
                Assert.assertEquals((long)3600L, (long)rec.getTTL());
                Assert.assertEquals((int)1, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDClass());
                ARecord aRec = (ARecord)rec;
                Assert.assertEquals((String)aRec.getAddress().getHostAddress(), (String)"127.0.0.1");
            }
        }.perform();
    }

    public void testEnsureMultipleRecords_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.2")));
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example3.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.3")));
                return this.addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testEnsureMultipleRecords_SameNameDiffIP_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.2")));
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.3")));
                return this.addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testFailToEnsure_invalidProxy_AssertException() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.recordCommands.setConfigurationProxy(new ConfigurationServiceProxy("http://localhost:7777/bogusendpoint"));
                return this.addRecords;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof RuntimeException));
                Assert.assertTrue((boolean)(exception.getCause() instanceof AxisFault));
            }

            @Override
            protected void doAssertions(List<Record> recordsMatched) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected List<Record> getARecordsInStore() throws Exception {
            List<Record> retVal;
            DnsRecord[] records = this.proxy.getDNSByType(1);
            if (records == null || records.length == 0) {
                retVal = Collections.emptyList();
            } else {
                retVal = new ArrayList<Record>();
                for (DnsRecord record : records) {
                    retVal.add(this.toRecord(record));
                }
            }
            return retVal;
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            List<Record> recordsToAdd = this.getRecordsToAdd();
            for (Record recordToAdd : recordsToAdd) {
                ARecord rec = (ARecord)recordToAdd;
                String[] command = new String[]{rec.getName().toString(), rec.getAddress().getHostAddress(), Long.toString(rec.getTTL())};
                this.recordCommands.ensureANAME(command);
            }
            this.doAssertions(this.getARecordsInStore());
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract List<Record> getRecordsToAdd() throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

