/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DNSRecordCommands_ensureMXRecords_Test
extends TestCase {
    public void testEnsureMXName_AssertRecordAdded() throws Exception {
        new TestPlan(){

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                return addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = records.iterator().next();
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName().toString());
                Assert.assertEquals((long)3600L, (long)rec.getTTL());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDClass());
                MXRecord mxRec = (MXRecord)rec;
                Assert.assertEquals((String)"mail1.example.domain.com.", (String)mxRec.getTarget().toString());
                Assert.assertEquals((int)1, (int)mxRec.getPriority());
            }
        }.perform();
    }

    public void testEnsureDupMX_AssertOneEntry() throws Exception {
        new TestPlan(){

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                ArrayList<Record> addRecords = new ArrayList<Record>();
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                return addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Record rec = records.iterator().next();
                Assert.assertEquals((String)"example.domain.com.", (String)rec.getName().toString());
                Assert.assertEquals((long)3600L, (long)rec.getTTL());
                Assert.assertEquals((int)15, (int)rec.getType());
                Assert.assertEquals((int)1, (int)rec.getDClass());
                MXRecord mxRec = (MXRecord)rec;
                Assert.assertEquals((String)"mail1.example.domain.com.", (String)mxRec.getTarget().toString());
                Assert.assertEquals((int)1, (int)mxRec.getPriority());
            }
        }.perform();
    }

    public void testEnsureMultipleRecords_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                ArrayList<Record> addRecords = new ArrayList<Record>();
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com.")));
                addRecords.add((Record)new MXRecord(Name.fromString((String)"example3.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail3.example.domain.com.")));
                return addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testEnsureMultipleRecords_SameNameDiffTarget_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.example.domain.com.")));
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail3.example.domain.com.")));
                return this.addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    public void testEnsureMultipleRecords_SameNameAndTargetDiffPriorities_AssertRecordsAdded() throws Exception {
        new TestPlan(){
            private List<Record> addRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.addRecords = new ArrayList<Record>();
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example1.domain.com."), 1, 3600L, 2, Name.fromString((String)"mail2.example.domain.com.")));
                this.addRecords.add((Record)new MXRecord(Name.fromString((String)"example3.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail3.example.domain.com.")));
                return this.addRecords;
            }

            @Override
            protected void doAssertions(List<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                for (Record record : this.addRecords) {
                    int index = records.indexOf(record);
                    Assert.assertTrue((index > -1 ? 1 : 0) != 0);
                    Record checkRecord = records.get(index);
                    Assert.assertEquals((Object)record, (Object)checkRecord);
                }
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected List<Record> getMXRecordsInStore() throws Exception {
            List<Record> retVal;
            DnsRecord[] records = this.proxy.getDNSByType(15);
            if (records == null || records.length == 0) {
                retVal = Collections.emptyList();
            } else {
                retVal = new ArrayList<Record>();
                for (DnsRecord record : records) {
                    retVal.add(this.toRecord(record));
                }
            }
            return retVal;
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            List<Record> recordsToAdd = this.getRecordsToAdd();
            for (Record recordToAdd : recordsToAdd) {
                MXRecord rec = (MXRecord)recordToAdd;
                String[] command = new String[]{rec.getName().toString(), rec.getTarget().toString(), Long.toString(rec.getTTL()), Integer.toString(rec.getPriority())};
                this.recordCommands.ensureMX(command);
            }
            this.doAssertions(this.getMXRecordsInStore());
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract List<Record> getRecordsToAdd() throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

