/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhind.config.EntityStatus;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.nhindirect.dns.util.DNSRecordUtil;
import org.nhindirect.dns.util.IPUtils;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.security.CERTConverter;

public class DNSServer_Function_Test
extends TestCase {
    private Certificate xCertToCert(X509Certificate cert) throws Exception {
        Certificate retVal = new Certificate();
        retVal.setOwner(DNSRecordUtil.getCertOwner(cert));
        retVal.setData(cert.getEncoded());
        return retVal;
    }

    public void testQueryARecord_AssertRecordsRetrieved_NoSOA() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example2.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Assert.assertEquals((String)"example2.domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryARecord_AssertRecordsRetrieved_SOARecord() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("sub2.example2.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createSOARecord("domain.com", "nsserver.domain.com", "master.domain.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("sub2.example2.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Assert.assertEquals((String)"sub2.example2.domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryARecordByAny_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example2.domain.com", "127.0.0.1");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example2.domain.com", 255));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)1, (int)records.size());
                Assert.assertEquals((String)"example2.domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryMutliARecords_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.2");
                recs.add(rec);
                rec = DNSRecordUtil.createSOARecord("domain.com", "nsserver.domain.com", "master.domain.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                Assert.assertEquals((String)"example.domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryARecords_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    public void testAnyQueryType_multipleTypesInRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.1");
                recs.add(rec);
                rec = DNSRecordUtil.createARecord("example.domain.com", "127.0.0.2");
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("example.domain.com", "domain.com", 1);
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("example.domain.com", 255));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)3, (int)records.size());
                Assert.assertEquals((String)"example.domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryCERTRecords_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<Certificate> recs = new ArrayList<Certificate>();
                X509Certificate cert = DNSRecordUtil.loadCertificate("bob.der");
                Certificate addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("gm2552.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("ryan.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                this.proxy.addCertificates(recs.toArray(new Certificate[recs.size()]));
                ArrayList<DnsRecord> soaRecs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createSOARecord("securehealthemail.com", "nsserver.securehealthemail.com", "master.securehealthemail.com");
                soaRecs.add(rec);
                this.proxy.addDNS(soaRecs.toArray(new DnsRecord[soaRecs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("gm2552.securehealthemail.com", 37));
                queries.add(new Query("ryan.securehealthemail.com", 255));
                queries.add(new Query("bob.somewhere.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                boolean foundGreg = false;
                boolean foundRyan = false;
                for (Record record : records) {
                    Assert.assertTrue((boolean)(record instanceof CERTRecord));
                    X509Certificate cert = (X509Certificate)CERTConverter.parseRecord((CERTRecord)((CERTRecord)record));
                    Assert.assertNotNull((Object)cert);
                    if (DNSRecordUtil.getCertOwner(cert).equals("gm2552@securehealthemail.com")) {
                        foundGreg = true;
                        continue;
                    }
                    if (!DNSRecordUtil.getCertOwner(cert).equals("ryan@securehealthemail.com")) continue;
                    foundRyan = true;
                }
                Assert.assertTrue((boolean)foundGreg);
                Assert.assertTrue((boolean)foundRyan);
            }
        }.perform();
    }

    public void testQueryCERTRecords_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("gm2552.securehealthemail.com", 37));
                queries.add(new Query("ryan.securehealthemail.com", 255));
                queries.add(new Query("bob.somewhere.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    public void testQueryIPKIXCERTRecords_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<Certificate> recs = new ArrayList<Certificate>();
                X509Certificate cert = DNSRecordUtil.loadCertificate("ryan.der");
                Certificate addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                cert = DNSRecordUtil.loadCertificate("gm2552.der");
                addCert = DNSServer_Function_Test.this.xCertToCert(cert);
                recs.add(addCert);
                Certificate ipkixCert = new Certificate();
                ipkixCert.setOwner("somewhere.com");
                ipkixCert.setData("http://localhost/somewhere.der".getBytes());
                ipkixCert.setPrivateKey(false);
                ipkixCert.setStatus(EntityStatus.ENABLED);
                recs.add(ipkixCert);
                this.proxy.addCertificates(recs.toArray(new Certificate[recs.size()]));
                ArrayList<DnsRecord> soaRecs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createSOARecord("securehealthemail.com", "nsserver.securehealthemail.com", "master.securehealthemail.com");
                soaRecs.add(rec);
                rec = DNSRecordUtil.createSOARecord("somewhere.com", "nsserver.somewhere.com", "master.somewhere.com");
                soaRecs.add(rec);
                this.proxy.addDNS(soaRecs.toArray(new DnsRecord[soaRecs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("somewhere.com", 37));
                queries.add(new Query("ryan.securehealthemail.com", 255));
                queries.add(new Query("bob.somewhere.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                boolean foundSomewhere = false;
                boolean foundRyan = false;
                for (Record record : records) {
                    Assert.assertTrue((boolean)(record instanceof CERTRecord));
                    CERTRecord certRect = (CERTRecord)record;
                    if (certRect.getCertType() == 253) {
                        Assert.assertEquals((String)"http://localhost/somewhere.der", (String)new String(certRect.getCert()));
                        foundSomewhere = true;
                        continue;
                    }
                    X509Certificate cert = (X509Certificate)CERTConverter.parseRecord((CERTRecord)((CERTRecord)record));
                    Assert.assertNotNull((Object)cert);
                    Assert.assertTrue((boolean)DNSRecordUtil.getCertOwner(cert).equals("ryan@securehealthemail.com"));
                    foundRyan = true;
                }
                Assert.assertTrue((boolean)foundSomewhere);
                Assert.assertTrue((boolean)foundRyan);
            }
        }.perform();
    }

    public void testQueryMXRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createMXRecord("domain.com", "example.domain.com", 1);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain.com", "example2.domain.com", 2);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain2.com", "example.domain2.com", 1);
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 15));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                Assert.assertEquals((String)"domain.com.", (String)records.iterator().next().getName().toString());
            }
        }.perform();
    }

    public void testQueryMXRecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createMXRecord("domain.com", "example.domain.com", 1);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain.com", "example2.domain.com", 2);
                recs.add(rec);
                rec = DNSRecordUtil.createMXRecord("domain2.com", "example.domain2.com", 1);
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    public void testQueryNSRecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createNSRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 2));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                Assert.assertEquals((String)"domain.com.", (String)records.iterator().next().getName().toString());
                for (Record rec : records) {
                    Assert.assertEquals((int)2, (int)rec.getType());
                }
            }
        }.perform();
    }

    public void testQueryNSRecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createNSRecord("domain.com", "ns.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain.com", "ns2.domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createNSRecord("domain2.com", "ns.domain2.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    public void testQueryCNAMERecord_AssertRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domainserver2.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domain2server.com", "domain2.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domainserver.com", 5));
                queries.add(new Query("domainserver2.com", 5));
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)2, (int)records.size());
                Assert.assertEquals((String)"domainserver.com.", (String)records.iterator().next().getName().toString());
                for (Record rec : records) {
                    Assert.assertEquals((int)5, (int)rec.getType());
                }
            }
        }.perform();
    }

    public void testQueryCNAMERecordByA_AssertNoRecordsRetrieved() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domainserver2.com", "domain.com");
                recs.add(rec);
                rec = DNSRecordUtil.createCNAMERecord("domain2server.com", "domain2.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 1));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    public void testQueryUnsupportedQueryType() throws Exception {
        new TestPlan(){

            @Override
            protected void addRecords() throws Exception {
                ArrayList<DnsRecord> recs = new ArrayList<DnsRecord>();
                DnsRecord rec = DNSRecordUtil.createCNAMERecord("domainserver.com", "domain.com");
                recs.add(rec);
                this.proxy.addDNS(recs.toArray(new DnsRecord[recs.size()]));
            }

            @Override
            protected Collection<Query> getTestQueries() throws Exception {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(new Query("domain.com", 28));
                return queries;
            }

            @Override
            protected void doAssertions(Collection<Record> records) throws Exception {
                Assert.assertNotNull(records);
                Assert.assertEquals((int)0, (int)records.size());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;

        TestPlan() {
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.addRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            ExtendedResolver resolver = new ExtendedResolver(IPUtils.getDNSLocalIps());
            resolver.setTimeout(300);
            resolver.setTCP(true);
            resolver.setPort(this.port);
            ArrayList<Record> retrievedRecord = new ArrayList<Record>();
            Collection<Query> queries = this.getTestQueries();
            for (Query query : queries) {
                Lookup lu = new Lookup(new Name(query.name), query.type);
                Cache ch = Lookup.getDefaultCache((int)1);
                ch.clearCache();
                lu.setResolver((Resolver)resolver);
                Record[] retRecords = lu.run();
                if (retRecords == null || retRecords.length <= 0) continue;
                retrievedRecord.addAll(Arrays.asList(retRecords));
            }
            this.doAssertions(retrievedRecord);
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
            Certificate[] certs = this.proxy.getCertificatesForOwner(null, null);
            if (certs != null && certs.length > 0) {
                long[] ids = new long[certs.length];
                int cnt = 0;
                for (Certificate cert : certs) {
                    ids[cnt++] = cert.getId();
                }
                this.proxy.removeCertificates(ids);
            }
            certs = this.proxy.getCertificatesForOwner("", null);
            Assert.assertNull((Object)certs);
        }

        protected abstract void addRecords() throws Exception;

        protected abstract Collection<Query> getTestQueries() throws Exception;

        protected abstract void doAssertions(Collection<Record> var1) throws Exception;
    }

    private static class Query {
        public String name;
        public int type;

        public Query(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

