/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns.tools;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.axis.AxisFault;
import org.apache.mina.util.AvailablePortFinder;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.dns.ConfigServiceDNSStore;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.tools.DNSRecordCommands;
import org.nhindirect.dns.util.BaseTestPlan;
import org.nhindirect.dns.util.ConfigServiceRunner;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;

public class DNSRecordCommands_removeRecords_Test
extends TestCase {
    public void testRemoveAllRecords_AssertRecordRemove() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.recordsToAdd.add((Record)new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                return this.recordsToAdd;
            }

            @Override
            protected List<DnsRecord> getRecordsToRemove(List<DnsRecord> addedRecords) throws Exception {
                return addedRecords;
            }

            @Override
            protected void doAssertions(List<Record> remainingRecords) throws Exception {
                Assert.assertNotNull(remainingRecords);
                Assert.assertEquals((int)0, (int)remainingRecords.size());
            }
        }.perform();
    }

    public void testRemoveOnlyARecords_AssertOnlyARecordRemoved() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;
            private List<Record> expectedRemainingRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.2")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.exampl2.domain.com.")));
                this.recordsToAdd.add((Record)new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                return this.recordsToAdd;
            }

            @Override
            protected List<DnsRecord> getRecordsToRemove(List<DnsRecord> addedRecords) throws Exception {
                ArrayList<DnsRecord> retVal = new ArrayList<DnsRecord>();
                this.expectedRemainingRecords = new ArrayList<Record>();
                for (DnsRecord addedRecord : addedRecords) {
                    if (addedRecord.getType() == 1) {
                        retVal.add(addedRecord);
                        continue;
                    }
                    this.expectedRemainingRecords.add(this.toRecord(addedRecord));
                }
                return retVal;
            }

            @Override
            protected void doAssertions(List<Record> remainingRecords) throws Exception {
                Assert.assertNotNull(remainingRecords);
                Assert.assertEquals((int)3, (int)remainingRecords.size());
                for (Record expectedRemaining : this.expectedRemainingRecords) {
                    int index = remainingRecords.indexOf(expectedRemaining);
                    Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
                    Record checkRecord = remainingRecords.get(index);
                    Assert.assertTrue((checkRecord.getType() != 1 ? 1 : 0) != 0);
                    Assert.assertEquals((Object)checkRecord, (Object)expectedRemaining);
                }
            }
        }.perform();
    }

    public void testRemoveAllExceptARecords_AssertAllExceptARecordRemoved() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;
            private List<Record> expectedRemainingRecords;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.2")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail1.example.domain.com.")));
                this.recordsToAdd.add((Record)new MXRecord(Name.fromString((String)"example2.domain.com."), 1, 3600L, 1, Name.fromString((String)"mail2.exampl2.domain.com.")));
                this.recordsToAdd.add((Record)new SOARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, Name.fromString((String)"ns1.example.domain.com."), Name.fromString((String)"gm2552.example.domain.com."), 1L, 3600L, 60L, 60L, 3600L));
                return this.recordsToAdd;
            }

            @Override
            protected List<DnsRecord> getRecordsToRemove(List<DnsRecord> addedRecords) throws Exception {
                ArrayList<DnsRecord> retVal = new ArrayList<DnsRecord>();
                this.expectedRemainingRecords = new ArrayList<Record>();
                for (DnsRecord addedRecord : addedRecords) {
                    if (addedRecord.getType() != 1) {
                        retVal.add(addedRecord);
                        continue;
                    }
                    this.expectedRemainingRecords.add(this.toRecord(addedRecord));
                }
                return retVal;
            }

            @Override
            protected void doAssertions(List<Record> remainingRecords) throws Exception {
                Assert.assertNotNull(remainingRecords);
                Assert.assertEquals((int)2, (int)remainingRecords.size());
                for (Record expectedRemaining : this.expectedRemainingRecords) {
                    int index = remainingRecords.indexOf(expectedRemaining);
                    Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
                    Record checkRecord = remainingRecords.get(index);
                    Assert.assertTrue((checkRecord.getType() == 1 ? 1 : 0) != 0);
                    Assert.assertEquals((Object)checkRecord, (Object)expectedRemaining);
                }
            }
        }.perform();
    }

    public void testFailureToRemove_invalidProxy_AssertException() throws Exception {
        new TestPlan(){
            private List<Record> recordsToAdd;

            @Override
            protected List<Record> getRecordsToAdd() throws Exception {
                this.recordsToAdd = new ArrayList<Record>();
                this.recordsToAdd.add((Record)new ARecord(Name.fromString((String)"example.domain.com."), 1, 3600L, InetAddress.getByName("127.0.0.1")));
                return this.recordsToAdd;
            }

            @Override
            protected List<DnsRecord> getRecordsToRemove(List<DnsRecord> addedRecords) throws Exception {
                this.recordCommands.setConfigurationProxy(new ConfigurationServiceProxy("http://localhost:7777/bogusendpoint"));
                return addedRecords;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)exception);
                Assert.assertTrue((boolean)(exception instanceof RuntimeException));
                Assert.assertTrue((boolean)(exception.getCause() instanceof AxisFault));
            }

            @Override
            protected void doAssertions(List<Record> remainingRecords) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected DNSServer server = null;
        protected ConfigurationServiceProxy proxy;
        protected DNSRecordCommands recordCommands;

        TestPlan() {
        }

        protected Record toRecord(DnsRecord rec) throws Exception {
            return Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
        }

        protected DnsRecord fromRecord(Record rec) throws Exception {
            DnsRecord newRec = new DnsRecord();
            newRec.setData(rec.rdataToWireCanonical());
            newRec.setDclass(rec.getDClass());
            newRec.setName(rec.getName().toString());
            newRec.setTtl(rec.getTTL());
            newRec.setType(rec.getType());
            return newRec;
        }

        protected List<Record> getRecordsInStore(int type) throws Exception {
            List<Record> retVal;
            DnsRecord[] records = this.proxy.getDNSByType(type);
            if (records == null || records.length == 0) {
                retVal = Collections.emptyList();
            } else {
                retVal = new ArrayList<Record>();
                for (DnsRecord record : records) {
                    retVal.add(this.toRecord(record));
                }
            }
            return retVal;
        }

        @Override
        protected void setupMocks() throws Exception {
            if (!ConfigServiceRunner.isServiceRunning()) {
                ConfigServiceRunner.startConfigService();
            }
            this.proxy = new ConfigurationServiceProxy(ConfigServiceRunner.getConfigServiceURL());
            this.cleanRecords();
            this.port = AvailablePortFinder.getNextAvailable((int)1024);
            DNSServerSettings settings = new DNSServerSettings();
            settings.setPort(this.port);
            this.server = new DNSServer((DNSStore)new ConfigServiceDNSStore(new URL(ConfigServiceRunner.getConfigServiceURL())), settings);
            this.server.start();
        }

        @Override
        protected void tearDownMocks() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }

        @Override
        protected void performInner() throws Exception {
            this.recordCommands = new DNSRecordCommands(this.proxy);
            List<Record> recordsToAdd = this.getRecordsToAdd();
            DnsRecord[] addRecs = new DnsRecord[recordsToAdd.size()];
            int cnt = 0;
            for (Record recordToAdd : recordsToAdd) {
                addRecs[cnt++] = this.fromRecord(recordToAdd);
            }
            this.proxy.addDNS(addRecs);
            addRecs = this.proxy.getDNSByType(255);
            List<DnsRecord> recordsToRemove = this.getRecordsToRemove(Arrays.asList(addRecs));
            for (DnsRecord recordToRemove : recordsToRemove) {
                switch (recordToRemove.getType()) {
                    case 1: {
                        this.recordCommands.removeANAME(new String[]{Long.toString(recordToRemove.getId())});
                        break;
                    }
                    case 15: {
                        this.recordCommands.removeMX(new String[]{Long.toString(recordToRemove.getId())});
                        break;
                    }
                    case 6: {
                        this.recordCommands.removeSOA(new String[]{Long.toString(recordToRemove.getId())});
                    }
                }
            }
            this.doAssertions(this.getRecordsInStore(255));
        }

        private void cleanRecords() throws Exception {
            DnsRecord[] rec = this.proxy.getDNSByType(255);
            if (rec != null && rec.length > 0) {
                this.proxy.removeDNS(rec);
            }
            rec = this.proxy.getDNSByType(255);
            Assert.assertNull((Object)rec);
        }

        protected abstract List<Record> getRecordsToAdd() throws Exception;

        protected abstract List<DnsRecord> getRecordsToRemove(List<DnsRecord> var1) throws Exception;

        protected abstract void doAssertions(List<Record> var1) throws Exception;
    }
}

