/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhind.config.CertPolicy;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.DnsRecord;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.annotation.ConfigServiceURL;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyFilterFactory;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;

public class ConfigServiceDNSStore
implements DNSStore {
    protected static final String DNS_CERT_POLICY_NAME_VAR = "org.nhindirect.dns.CertPolicyName";
    protected static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    protected static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.dns.JCEProviderName";
    protected static final Log LOGGER = LogFactory.getFactory().getInstance(ConfigServiceDNSStore.class);
    protected Map<String, Record> soaRecords = null;
    protected PolicyFilter polFilter = null;
    protected PolicyExpression polExpression = null;
    final ConfigurationServiceProxy proxy;

    public static String getJCEProviderName() {
        String retVal = System.getProperty(JCE_PROVIDER_STRING_SYS_PARAM);
        if (retVal == null || retVal.isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        if (name == null || name.isEmpty()) {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, DEFAULT_JCE_PROVIDER_STRING);
        } else {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, name);
        }
    }

    @Inject
    public ConfigServiceDNSStore(@ConfigServiceURL URL serviceURL) {
        this.proxy = new ConfigurationServiceProxy(serviceURL.toString());
        try {
            this.configCertPolicy();
        }
        catch (DNSException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configCertPolicy() throws DNSException {
        block7: {
            block8: {
                String polName = System.getProperty(DNS_CERT_POLICY_NAME_VAR);
                if (StringUtils.isEmpty((String)polName)) break block8;
                ByteArrayInputStream inStream = null;
                LOGGER.info((Object)("Certificate policy name " + polName + " has been configured."));
                try {
                    CertPolicy policy = this.proxy.getPolicyByName(polName);
                    if (policy == null) {
                        LOGGER.warn((Object)("Certificate policy " + polName + " could not be found in the system.  Falling back to no policy."));
                        IOUtils.closeQuietly((InputStream)inStream);
                        return;
                    }
                    PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((PolicyLexicon)PolicyLexicon.valueOf((String)policy.getLexicon().getValue()));
                    inStream = new ByteArrayInputStream(policy.getPolicyData());
                    this.polExpression = parser.parse((InputStream)inStream);
                    this.polFilter = PolicyFilterFactory.getInstance();
                    IOUtils.closeQuietly((InputStream)inStream);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Error loading and compling certificate policy " + polName + ".  Will fallback to no policy filter."), (Throwable)e);
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(inStream);
                }
                break block7;
            }
            LOGGER.info((Object)"No certificate policy has been configured.");
        }
    }

    @Override
    public Message get(Message request) throws DNSException {
        Iterator iter;
        LOGGER.trace((Object)"get(Message) Entered");
        if (request == null) {
            throw new DNSException(DNSError.newError(1));
        }
        Header header = request.getHeader();
        if (header.getFlag(0) || header.getRcode() != 0) {
            throw new DNSException(DNSError.newError(1));
        }
        if (header.getOpcode() != 0) {
            throw new DNSException(DNSError.newError(4));
        }
        Record question = request.getQuestion();
        if (question == null || question.getDClass() != 1) {
            throw new DNSException(DNSError.newError(4));
        }
        Record queryRecord = request.getQuestion();
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Recieved Query Request:");
            builder.append("\r\n\tName: " + name.toString());
            builder.append("\r\n\tType: " + type);
            builder.append("\r\n\tDClass: " + queryRecord.getDClass());
            LOGGER.debug((Object)builder.toString());
        }
        ArrayList lookupRecords = null;
        switch (question.getType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 33: {
                RRset set;
                try {
                    set = this.processGenericRecordRequest(name.toString(), type);
                    if (set == null) break;
                    lookupRecords = new ArrayList();
                    iter = set.rrs();
                    while (iter.hasNext()) {
                        lookupRecords.add(iter.next());
                    }
                    break;
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call failed: " + e.getMessage(), e);
                }
            }
            case 37: {
                RRset set = this.processCERTRecordRequest(name.toString());
                if (set == null) break;
                lookupRecords = new ArrayList();
                iter = set.rrs();
                while (iter.hasNext()) {
                    lookupRecords.add(iter.next());
                }
                break;
            }
            case 255: {
                Collection<Record> genRecs = this.processGenericANYRecordRequest(name.toString());
                RRset certRecs = this.processCERTRecordRequest(name.toString());
                if (genRecs == null && certRecs == null) break;
                lookupRecords = new ArrayList();
                if (genRecs != null) {
                    lookupRecords.addAll(genRecs);
                }
                if (certRecs == null) break;
                Iterator iter2 = certRecs.rrs();
                while (iter2.hasNext()) {
                    lookupRecords.add(iter2.next());
                }
                break;
            }
            default: {
                LOGGER.debug((Object)("Query Type " + type + " not implemented"));
                throw new DNSException(DNSError.newError(4), "Query Type " + type + " not implemented");
            }
        }
        if (lookupRecords == null || lookupRecords.size() == 0) {
            LOGGER.debug((Object)"No records found.");
            return null;
        }
        Message response = new Message(request.getHeader().getID());
        response.getHeader().setFlag(0);
        if (request.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        iter = lookupRecords.iterator();
        while (iter.hasNext()) {
            response.addRecord((Record)iter.next(), 1);
        }
        response.getHeader().setFlag(5);
        Record soaRecord = this.checkForSoaRecord(name.toString());
        if (soaRecord != null) {
            response.addRecord(soaRecord, 2);
        }
        LOGGER.trace((Object)"get(Message) Exit");
        return response;
    }

    protected RRset processGenericRecordRequest(String name, int type) throws DNSException {
        DnsRecord[] records;
        try {
            records = this.proxy.getDNSByNameAndType(name, type);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for DNS records failed: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            return null;
        }
        RRset retVal = new RRset();
        try {
            for (DnsRecord record : records) {
                Record rec = Record.newRecord((Name)Name.fromString((String)record.getName()), (int)record.getType(), (int)record.getDclass(), (long)record.getTtl(), (byte[])record.getData());
                retVal.addRR(rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing generic record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    protected Collection<Record> processGenericANYRecordRequest(String name) throws DNSException {
        DnsRecord[] records;
        try {
            records = this.proxy.getDNSByNameAndType(name, 255);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for DNS records failed: " + e.getMessage(), e);
        }
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<Record> retVal = new ArrayList<Record>();
        try {
            for (DnsRecord record : records) {
                Record rec = Record.newRecord((Name)Name.fromString((String)record.getName()), (int)record.getType(), (int)record.getDclass(), (long)record.getTtl(), (byte[])record.getData());
                retVal.add(rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing generic record data: " + e.getMessage(), e);
        }
        return retVal;
    }

    protected RRset processCERTRecordRequest(String name) throws DNSException {
        Certificate[] certs;
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        try {
            certs = this.proxy.getCertificatesForOwner(name, null);
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
        }
        if (certs == null || certs.length == 0) {
            int previousIndex = 0;
            int replaceIndex = 0;
            while ((replaceIndex = name.indexOf(".", previousIndex)) > -1) {
                char[] chars = name.toCharArray();
                chars[replaceIndex] = 64;
                try {
                    certs = this.proxy.getCertificatesForOwner(String.copyValueOf(chars), null);
                }
                catch (Exception e) {
                    throw new DNSException(DNSError.newError(2), "DNS service proxy call for certificates failed: " + e.getMessage(), e);
                }
                if (certs != null && certs.length > 0 || replaceIndex >= name.length() - 1) break;
                previousIndex = replaceIndex + 1;
            }
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        RRset retVal = new RRset();
        try {
            for (Certificate cert : certs) {
                int certRecordType = 1;
                byte[] retData = null;
                X509Certificate xCert = null;
                try {
                    CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])cert.getData());
                    xCert = cont.getCert();
                    if (!this.isCertCompliantWithPolicy(xCert)) continue;
                    retData = xCert.getEncoded();
                }
                catch (CertificateConversionException e) {
                    // empty catch block
                }
                if (xCert == null) {
                    try {
                        retData = cert.getData();
                        URL url = new URL(new String(retData));
                        certRecordType = 253;
                    }
                    catch (Exception e) {
                        throw new DNSException(DNSError.newError(2), "Failure while parsing CERT record data: " + e.getMessage(), e);
                    }
                }
                int keyTag = 0;
                int alg = 0;
                if (xCert != null && xCert.getPublicKey() instanceof RSAKey) {
                    RSAKey key = (RSAKey)((Object)xCert.getPublicKey());
                    byte[] modulus = key.getModulus().toByteArray();
                    keyTag = modulus[modulus.length - 2] << 8 & 0xFF00;
                    keyTag |= modulus[modulus.length - 1] & 0xFF;
                    alg = 5;
                }
                CERTRecord rec = new CERTRecord(Name.fromString((String)name), 1, 86400L, certRecordType, keyTag, alg, retData);
                retVal.addRR((Record)rec);
            }
        }
        catch (Exception e) {
            throw new DNSException(DNSError.newError(2), "Failure while parsing CERT record data: " + e.getMessage(), e);
        }
        return retVal.size() == 0 ? null : retVal;
    }

    protected synchronized Record checkForSoaRecord(String questionName) {
        Record retVal;
        block8: {
            if (!questionName.endsWith(".")) {
                questionName = questionName + ".";
            }
            if (this.soaRecords == null) {
                DnsRecord[] getRecs = null;
                try {
                    getRecs = this.proxy.getDNSByType(6);
                    if (getRecs == null || getRecs.length == 0) {
                        this.soaRecords = Collections.emptyMap();
                    } else {
                        this.soaRecords = new HashMap<String, Record>();
                        for (DnsRecord rec : getRecs) {
                            Record newRec = Record.newRecord((Name)Name.fromString((String)rec.getName()), (int)6, (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
                            this.soaRecords.put(newRec.getName().toString(), newRec);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Failed to load SOA records from config service.");
                }
            }
            retVal = null;
            if (this.soaRecords.size() <= 0 || (retVal = this.soaRecords.get(questionName)) != null) break block8;
            int index = -1;
            while ((index = questionName.indexOf(".")) > 0 && index < questionName.length() - 1 && (retVal = this.soaRecords.get(questionName = questionName.substring(index + 1))) == null) {
            }
        }
        return retVal;
    }

    protected boolean isCertCompliantWithPolicy(X509Certificate cert) {
        if (this.polFilter == null) {
            return true;
        }
        try {
            return this.polFilter.isCompliant(cert, this.polExpression);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error testing certificate for policy compliance.  Default to compliant.", (Throwable)e);
            return true;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

