/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.Thumbprint;
import org.nhindirect.stagent.cert.X509CertificateEx;

public abstract class AbstractKeyStoreManagerCertificateStore
extends CertificateStore {
    protected KeyStoreProtectionManager storeMgr;

    public AbstractKeyStoreManagerCertificateStore() {
    }

    public AbstractKeyStoreManagerCertificateStore(KeyStoreProtectionManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    public void setKeyStoreManager(KeyStoreProtectionManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
        try {
            for (Map.Entry entry : this.storeMgr.getAllEntries().entrySet()) {
                if (!(entry.getValue() instanceof KeyStore.PrivateKeyEntry)) continue;
                KeyStore.PrivateKeyEntry privEntry = (KeyStore.PrivateKeyEntry)entry.getValue();
                retVal.add(X509CertificateEx.fromX509Certificate((X509Certificate)privEntry.getCertificate(), privEntry.getPrivateKey()));
            }
            return retVal;
        }
        catch (Exception e) {
            throw new NHINDException((Object)AgentError.Unexpected, "Failed to get key entries from PKCS11 store.", e);
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        return this.getAllCertificates().contains(cert);
    }

    @Override
    public void add(X509Certificate cert) {
        if (!(this.storeMgr instanceof MutableKeyStoreProtectionManager)) {
            throw new IllegalStateException("The store manager is a MutableKeyStoreProtectionManager instance");
        }
        if (!(cert instanceof X509CertificateEx) || !((X509CertificateEx)cert).hasPrivateKey()) {
            throw new IllegalArgumentException("PKCS11 certificates require a private key");
        }
        X509CertificateEx exCert = (X509CertificateEx)cert;
        String alias = Thumbprint.toThumbprint(cert).toString();
        KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(exCert.getPrivateKey(), new Certificate[]{cert});
        try {
            ((MutableKeyStoreProtectionManager)this.storeMgr).setEntry(alias, (KeyStore.Entry)entry);
        }
        catch (Exception e) {
            throw new NHINDException((Object)AgentError.Unexpected, "Failed to add key entry into PKCS11 store.", e);
        }
    }

    @Override
    public void remove(X509Certificate cert) {
        if (!(this.storeMgr instanceof MutableKeyStoreProtectionManager)) {
            throw new IllegalStateException("The store manager is a MutableKeyStoreProtectionManager instance");
        }
        try {
            String aliasToRemove = null;
            for (String alias : this.storeMgr.getAllEntries().keySet()) {
                KeyStore.PrivateKeyEntry privEntry;
                KeyStore.Entry entry = this.storeMgr.getEntry(alias);
                if (!(entry instanceof KeyStore.PrivateKeyEntry) || !cert.equals((privEntry = (KeyStore.PrivateKeyEntry)entry).getCertificate())) continue;
                aliasToRemove = alias;
                break;
            }
            if (aliasToRemove != null) {
                MutableKeyStoreProtectionManager mutMgr = (MutableKeyStoreProtectionManager)this.storeMgr;
                mutMgr.clearEntry(aliasToRemove);
            }
        }
        catch (Exception e) {
            throw new NHINDException((Object)AgentError.Unexpected, "Failed to remove key entry from PKCS11 store.", e);
        }
    }
}

