/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.mail.MailStandard;
import org.nhindirect.stagent.mail.MimeEntity;

public class SMIMEStandard
extends MailStandard {
    public static final String MediaType_Multipart = "multipart";
    public static final String MultiPartType_Mixed = "multipart/mixed;";
    public static final String MultiPartType_Signed = "multipart/signed; protocol=\"application/pkcs7-signature\";";
    public static final String MICAlgorithmKey = "micalg";
    public static final String CmsEnvelopeMediaType = "application/pkcs7-mime";
    public static final String CmsEnvelopeMediaTypeAlt = "application/x-pkcs7-mime";
    public static final String EncryptedContentTypeHeaderValue = "application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"";
    public static final String EncryptedContentMediaType = "application/pkcs7-mime";
    public static final String EncryptedContentMediaTypeAlternative = "application/x-pkcs7-mime";
    public static final String SignatureContentTypeHeaderValue = "application/pkcs7-signature; name=\"smime.p7s\"";
    public static final String SignatureContentMediaType = "application/pkcs7-signature";
    public static final String SignatureContentMediaTypeAlternative = "application/x-pkcs7-signature";
    public static final String SignatureDisposition = "attachment; filename=\"smime.p7s\"";
    public static final String SmimeTypeParameterKey = "smime-type";
    public static final String EnvelopedDataSmimeType = "enveloped-data";
    public static final String SignedDataSmimeType = "signed-data";
    public static final String DefaultFileName = "smime.p7m";

    public static boolean isContentCms(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        return contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime");
    }

    public static boolean isContentEncrypted(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        return SMIMEStandard.isContentCms(contentType) && contentType.getParameter(SmimeTypeParameterKey) != null && contentType.getParameter(SmimeTypeParameterKey).equals(EnvelopedDataSmimeType);
    }

    public static boolean isContentEnvelopedSignature(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        return SMIMEStandard.isContentCms(contentType) && contentType.getParameter(SmimeTypeParameterKey) != null && contentType.getParameter(SmimeTypeParameterKey).equals(SignedDataSmimeType);
    }

    public static boolean isContentMultipartSignature(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        return contentType.match(MultiPartType_Signed);
    }

    public static boolean isContentDetachedSignature(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        return contentType.match(SignatureContentMediaType) || contentType.match(SignatureContentMediaTypeAlternative);
    }

    public static boolean isEncrypted(MimeMessage entity) {
        return SMIMEStandard.isContentEncrypted(SMIMEStandard.getContentType(entity)) && SMIMEStandard.verifyEncoding(entity);
    }

    public static boolean isSignedEnvelope(MimeMessage entity) {
        return SMIMEStandard.isContentEnvelopedSignature(SMIMEStandard.getContentType(entity)) && SMIMEStandard.verifyEncoding(entity);
    }

    public static boolean isSignedEnvelope(MimeEntity entity) {
        return SMIMEStandard.isContentEnvelopedSignature(SMIMEStandard.getContentType(entity)) && SMIMEStandard.verifyEncoding(entity);
    }

    public static boolean isDetachedSignature(MimeMessage entity) {
        return SMIMEStandard.isContentDetachedSignature(SMIMEStandard.getContentType(entity)) && SMIMEStandard.verifyEncoding(entity);
    }

    private static ContentType getContentType(MimeEntity entity) {
        try {
            return new ContentType(entity.getContentType());
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    private static ContentType getContentType(MimeMessage entity) {
        try {
            return new ContentType(entity.getContentType());
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    static boolean verifyEncoding(MimeEntity entity) {
        try {
            String header = entity.getHeader("Content-Transfer-Encoding", null);
            return header != null && header.matches("base64");
        }
        catch (MessagingException messagingException) {
            return false;
        }
    }

    static boolean verifyEncoding(MimeMessage entity) {
        try {
            String header = entity.getHeader("Content-Transfer-Encoding", null);
            return header != null && header.matches("base64");
        }
        catch (MessagingException messagingException) {
            return false;
        }
    }

    public static String toString(DigestAlgorithm algorithm) {
        switch (algorithm) {
            default: {
                throw new IllegalArgumentException();
            }
            case SHA1: {
                return "sha1";
            }
            case SHA256: {
                return "sha256";
            }
            case SHA384: {
                return "sha384";
            }
            case SHA512: 
        }
        return "sha512";
    }
}

