/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyFilterFactory;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.SignerCertPair;
import org.nhindirect.stagent.policy.PolicyResolver;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.annotation.TrustPolicyFilter;
import org.nhindirect.stagent.trust.annotation.TrustPolicyResolver;

public class TrustModel {
    public static final TrustModel Default = new TrustModel();
    private final TrustChainValidator certChainValidator;
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TrustModel.class);
    private PolicyResolver trustPolicyResolver;
    private PolicyFilter policyFilter;

    public TrustModel() {
        this.certChainValidator = new TrustChainValidator();
        try {
            this.policyFilter = PolicyFilterFactory.getInstance();
        }
        catch (PolicyParseException e) {
            throw new AgentException(AgentError.Unexpected, "Failed to create policy filter object.", (Exception)((Object)e));
        }
    }

    @Inject
    public TrustModel(TrustChainValidator validator) {
        this.certChainValidator = validator;
        try {
            this.policyFilter = PolicyFilterFactory.getInstance();
        }
        catch (PolicyParseException e) {
            throw new AgentException(AgentError.Unexpected, "Failed to create policy filter object.", (Exception)((Object)e));
        }
    }

    public TrustChainValidator getCertChainValidator() {
        return this.certChainValidator;
    }

    @Inject(optional=true)
    public void setPolicyFilter(@TrustPolicyFilter PolicyFilter policyFilter) {
        this.policyFilter = policyFilter;
    }

    public PolicyFilter getPolicyFilter() {
        return this.policyFilter;
    }

    @Inject(optional=true)
    public void setTrustPolicyResolver(@TrustPolicyResolver PolicyResolver trustPolicyResolver) {
        this.trustPolicyResolver = trustPolicyResolver;
    }

    public PolicyResolver getTrustPolicyResolver() {
        return this.trustPolicyResolver;
    }

    public void enforce(IncomingMessage message) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        if (!message.hasSignatures()) {
            throw new AgentException(AgentError.UntrustedMessage);
        }
        this.findSenderSignatures(message);
        if (!message.hasSenderSignatures()) {
            throw new AgentException(AgentError.MissingSenderSignature);
        }
        NHINDAddressCollection recipients = message.getDomainRecipients();
        for (NHINDAddress recipient : recipients) {
            recipient.setStatus(TrustEnforcementStatus.Failed);
            if (recipient.getCertificates() != null) {
                DefaultMessageSignatureImpl trustedSignature = this.findTrustedSignature(message, recipient, recipient.getTrustAnchors());
                if (trustedSignature != null) {
                    recipient.setStatus(trustedSignature.isThumbprintVerified() ? TrustEnforcementStatus.Success : TrustEnforcementStatus.Success_ThumbprintMismatch);
                    continue;
                }
                LOGGER.warn((Object)("enforce(IncomingMessage message) - could not find a trusted certificate for recipient " + recipient.getAddress()));
                continue;
            }
            LOGGER.warn((Object)("enforce(IncomingMessage message) - recipient " + recipient.getAddress() + " does not have a bound certificate"));
        }
    }

    public void enforce(OutgoingMessage message) {
        if (message == null) {
            throw new IllegalArgumentException();
        }
        NHINDAddress sender = message.getSender();
        NHINDAddressCollection recipients = message.getRecipients();
        for (NHINDAddress recipient : recipients) {
            recipient.setStatus(TrustEnforcementStatus.Failed);
            Collection<X509Certificate> certs = recipient.getCertificates();
            if (certs == null || certs.size() == 0) {
                LOGGER.warn((Object)("enforce(OutgoingMessage message) - recipient " + recipient.getAddress() + " has no bound certificates"));
            }
            recipient.setCertificates(this.findTrustedCerts(certs, sender.getTrustAnchors()));
            if (recipient.hasCertificates()) {
                recipient.setStatus(TrustEnforcementStatus.Success);
                continue;
            }
            LOGGER.warn((Object)("enforce(OutgoingMessage message) - could not trust any certificates for recipient " + recipient.getAddress()));
        }
    }

    protected Collection<X509Certificate> findTrustedCerts(Collection<X509Certificate> certs, Collection<X509Certificate> anchors) {
        if (certs == null) {
            return null;
        }
        ArrayList<X509Certificate> trustedCerts = null;
        for (X509Certificate cert : certs) {
            if (!this.certChainValidator.isTrusted(cert, anchors)) continue;
            if (trustedCerts == null) {
                trustedCerts = new ArrayList<X509Certificate>();
            }
            trustedCerts.add(cert);
        }
        return trustedCerts;
    }

    protected void findSenderSignatures(IncomingMessage message) {
        message.setSenderSignatures(null);
        NHINDAddress sender = message.getSender();
        ArrayList<DefaultMessageSignatureImpl> senderSignatures = new ArrayList<DefaultMessageSignatureImpl>();
        Collection<SignerCertPair> individualSenders = CryptoExtensions.findSignersByName(message.getSignature(), sender.getAddress(), null);
        Collection<SignerCertPair> orgSenders = CryptoExtensions.findSignersByName(message.getSignature(), sender.getHost(), Arrays.asList(sender.getAddress()));
        for (SignerCertPair pair : individualSenders) {
            senderSignatures.add(new DefaultMessageSignatureImpl(pair.getSigner(), false, pair.getCertificate()));
        }
        for (SignerCertPair pair : orgSenders) {
            senderSignatures.add(new DefaultMessageSignatureImpl(pair.getSigner(), true, pair.getCertificate()));
        }
        message.setSenderSignatures(senderSignatures);
    }

    protected DefaultMessageSignatureImpl findTrustedSignature(IncomingMessage message, Collection<X509Certificate> anchors) {
        return this.findTrustedSignature(message, null, anchors);
    }

    protected DefaultMessageSignatureImpl findTrustedSignature(IncomingMessage message, InternetAddress recipient, Collection<X509Certificate> anchors) {
        NHINDAddress sender = message.getSender();
        Collection<DefaultMessageSignatureImpl> signatures = message.getSenderSignatures();
        DefaultMessageSignatureImpl lastTrustedSignature = null;
        for (DefaultMessageSignatureImpl signature : signatures) {
            boolean certTrustedAndInPolicy;
            boolean bl = certTrustedAndInPolicy = this.certChainValidator.isTrusted(signature.getSignerCert(), anchors) && signature.checkSignature();
            if (certTrustedAndInPolicy && recipient != null) {
                certTrustedAndInPolicy = this.isCertPolicyCompliant(recipient, signature.getSignerCert());
            }
            if (!certTrustedAndInPolicy) continue;
            if (!sender.hasCertificates()) {
                return signature;
            }
            if (signature.checkThumbprint(sender)) {
                return signature;
            }
            lastTrustedSignature = signature;
        }
        return lastTrustedSignature;
    }

    protected boolean isCertPolicyCompliant(InternetAddress recipient, X509Certificate cert) {
        boolean isCompliant = true;
        if (this.trustPolicyResolver != null && this.policyFilter != null) {
            Collection<PolicyExpression> expressions = this.trustPolicyResolver.getIncomingPolicy(recipient);
            for (PolicyExpression expression : expressions) {
                try {
                    if (this.policyFilter.isCompliant(cert, expression)) continue;
                    isCompliant = false;
                    break;
                }
                catch (PolicyRequiredException requiredException) {
                    isCompliant = false;
                    break;
                }
                catch (PolicyProcessException processException) {
                    throw new AgentException(AgentError.InvalidPolicy, (Exception)((Object)processException));
                }
            }
        }
        return isCompliant;
    }
}

