/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.tools.policyvalidate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileField
extends JPanel {
    static final long serialVersionUID = 8783281209944790372L;
    private JLabel label;
    private JTextField text;
    private JButton search;

    public FileField(String labelText, String file) {
        this.setLayout(new BorderLayout());
        this.label = new JLabel(labelText);
        this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().getSize().height));
        this.text = new JTextField();
        this.text.setPreferredSize(new Dimension(250, this.label.getPreferredSize().getSize().height));
        this.add((Component)this.label, "North");
        JPanel filePanel = new JPanel(new BorderLayout());
        this.search = new JButton("...");
        this.search.setPreferredSize(new Dimension(30, this.text.getPreferredSize().getSize().height));
        JPanel fileWithSearchPanel = new JPanel(new FlowLayout(0));
        fileWithSearchPanel.add(this.text);
        fileWithSearchPanel.add(this.search);
        filePanel.add((Component)fileWithSearchPanel, "North");
        this.add(filePanel);
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileField.this.selectFile();
            }
        });
    }

    private void selectFile() {
        int result;
        File startFile;
        JFileChooser fc = new JFileChooser();
        fc.setDragEnabled(false);
        if (!this.text.getText().trim().isEmpty() && (startFile = new File(this.text.getText())).exists()) {
            fc.setCurrentDirectory(startFile);
        }
        if ((result = fc.showOpenDialog(this)) == 0) {
            this.text.setText(fc.getSelectedFile().getPath());
        }
    }

    public File getFile() {
        return new File(this.text.getText().trim());
    }

    public void setFile(File fl) {
        if (fl != null) {
            this.text.setText(fl.getAbsolutePath());
        } else {
            this.text.setText("");
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.text.setEnabled(b);
        this.search.setEnabled(b);
    }
}

