/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.tools.policyvalidate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.text.Document;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyFilterFactory;
import org.nhindirect.policy.PolicyGrammarException;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.impl.machine.StackMachineCompiler;
import org.nhindirect.policy.tools.policyvalidate.FileField;

public class ValidatePanel
extends JPanel {
    static final long serialVersionUID = -1058079566562354445L;
    protected FileField policyFileField;
    protected FileField certFileField;
    protected JTextArea reportText;
    protected JButton cmdValidate;
    protected boolean feedMode = false;
    protected PolicyLexicon feedLexicon;
    protected Document feed;

    public ValidatePanel() {
        this.initUI();
        this.addActions();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.policyFileField = new FileField("Policy Definition File:", "");
        this.certFileField = new FileField("Certificate File: ", "");
        JPanel filePanel = new JPanel(new GridLayout(1, 2));
        filePanel.add(this.certFileField);
        filePanel.add(this.policyFileField);
        this.add((Component)filePanel, "North");
        JLabel reportHeaderLabel = new JLabel("Validation Report");
        this.reportText = new JTextArea();
        this.reportText.setLineWrap(true);
        this.reportText.setWrapStyleWord(true);
        this.reportText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.reportText);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportPanel.add((Component)reportHeaderLabel, "North");
        reportPanel.add((Component)scrollPane, "Center");
        this.add((Component)reportPanel, "Center");
        this.cmdValidate = new JButton("Validate");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.cmdValidate);
        this.add((Component)buttonPanel, "South");
    }

    private void addActions() {
        this.cmdValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatePanel.this.validateCert();
            }
        });
    }

    public void setFeedMode(PolicyLexicon lexicon, Document feed) {
        this.feedLexicon = lexicon;
        this.feedMode = true;
        this.feed = feed;
        this.policyFileField.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCert() {
        this.reportText.setText("");
        File certFile = this.certFileField.getFile();
        File policyFile = this.policyFileField.getFile();
        if (!certFile.exists()) {
            JOptionPane.showMessageDialog(this, "Certificate file does not exist or cannot be found.", "Invalid Cert File", 0);
            return;
        }
        InputStream policyInput = null;
        if (!this.feedMode) {
            if (!policyFile.exists()) {
                JOptionPane.showMessageDialog(this, "Policy file does not exist or cannot be found.", "Invalid Policy File", 0);
                return;
            }
            try {
                policyInput = FileUtils.openInputStream((File)policyFile);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Could not load policy from file: " + e.getMessage(), "Invalid Policy File", 0);
                return;
            }
        }
        try {
            int length = this.feed.getLength();
            policyInput = IOUtils.toInputStream((String)this.feed.getText(0, length));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not load policy: " + e.getMessage(), "Invalid Policy", 0);
            return;
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(FileUtils.openInputStream((File)certFile));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not load certificate from file: " + e.getMessage(), "Invalid Cert File", 0);
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d yyyy HH:mm:ss", Locale.getDefault());
        StringBuilder reportTextBuilder = new StringBuilder("Validation run at " + dateFormat.format(Calendar.getInstance(Locale.getDefault()).getTime()) + "\r\n\r\n");
        try {
            PolicyLexiconParser parser = this.feedMode ? PolicyLexiconParserFactory.getInstance(this.feedLexicon) : PolicyLexiconParserFactory.getInstance(PolicyLexicon.XML);
            PolicyExpression policyExpression = parser.parse(policyInput);
            StackMachineCompiler compiler = new StackMachineCompiler();
            compiler.setReportModeEnabled(true);
            PolicyFilter filter = PolicyFilterFactory.getInstance(compiler);
            if (filter.isCompliant(cert, policyExpression) && compiler.getCompilationReport().isEmpty()) {
                reportTextBuilder.append("Certificate is compliant with the provided policy.");
            } else {
                reportTextBuilder.append("Certificate is NOT compliant with the provided policy.\r\n\r\n");
                Collection<String> report = compiler.getCompilationReport();
                if (!report.isEmpty()) {
                    for (String reportEntry : report) {
                        reportTextBuilder.append(reportEntry + "\r\n");
                    }
                }
            }
        }
        catch (PolicyRequiredException e) {
            reportTextBuilder.append("Validation Successful\r\nCertificate is missing a required field\r\n\t" + e.getMessage());
        }
        catch (PolicyGrammarException e) {
            reportTextBuilder.append("Validation Failed\r\nError compiling policy\r\n\t" + e.getMessage());
        }
        catch (Exception e) {
            ByteArrayOutputStream str = new ByteArrayOutputStream();
            PrintStream printStr = new PrintStream(str);
            e.printStackTrace();
            e.printStackTrace(printStr);
            String stackTrace = new String(str.toByteArray());
            reportTextBuilder.append("Validation Failed\r\nError compiling or proccessing policy\r\n\t" + e.getMessage() + "\r\n" + stackTrace);
        }
        finally {
            this.reportText.setText(reportTextBuilder.toString());
            IOUtils.closeQuietly((InputStream)policyInput);
        }
    }
}

