/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.provider;

import com.google.inject.Provider;
import java.lang.reflect.Constructor;
import org.apache.http.client.HttpClient;
import org.nhindirect.common.rest.AbstractSecuredService;
import org.nhindirect.common.rest.HttpClientFactory;
import org.nhindirect.common.rest.ServiceSecurityManager;

public class DefaultRESTServiceProvider<T>
implements Provider<T> {
    protected final String serviceURL;
    protected final HttpClient client;
    protected final ServiceSecurityManager securityManager;
    protected final Class<? extends AbstractSecuredService> clazz;

    protected static ServiceSecurityManager getInitiziedSecurityManager(Provider<ServiceSecurityManager> securityManagerProvider) {
        ServiceSecurityManager retVal = (ServiceSecurityManager)securityManagerProvider.get();
        retVal.init();
        return retVal;
    }

    public DefaultRESTServiceProvider(String serviceURL, Provider<ServiceSecurityManager> securityManagerProvider, Class<? extends AbstractSecuredService> clazz) {
        this(serviceURL, HttpClientFactory.createHttpClient(), DefaultRESTServiceProvider.getInitiziedSecurityManager(securityManagerProvider), clazz);
    }

    public DefaultRESTServiceProvider(String serviceURL, ServiceSecurityManager securityManager, Class<? extends AbstractSecuredService> clazz) {
        this(serviceURL, HttpClientFactory.createHttpClient(), securityManager, clazz);
    }

    public DefaultRESTServiceProvider(String serviceURL, HttpClientFactory factory, Provider<ServiceSecurityManager> securityManagerProvider, Class<? extends AbstractSecuredService> clazz) {
        this(serviceURL, factory.createHttpClient(), DefaultRESTServiceProvider.getInitiziedSecurityManager(securityManagerProvider), clazz);
    }

    public DefaultRESTServiceProvider(String serviceURL, HttpClientFactory factory, ServiceSecurityManager securityManager, Class<? extends AbstractSecuredService> clazz) {
        this(serviceURL, factory.createHttpClient(), securityManager, clazz);
    }

    public DefaultRESTServiceProvider(String serviceURL, HttpClient client, ServiceSecurityManager securityManager, Class<? extends AbstractSecuredService> clazz) {
        this.serviceURL = serviceURL;
        this.client = client;
        this.securityManager = securityManager;
        this.clazz = clazz;
    }

    public T get() {
        AbstractSecuredService retVal = null;
        try {
            Constructor<? extends AbstractSecuredService> ctr = this.clazz.getDeclaredConstructor(String.class, HttpClient.class, ServiceSecurityManager.class);
            retVal = ctr.newInstance(this.serviceURL, this.client, this.securityManager);
        }
        catch (Exception e) {
            throw new IllegalStateException("REST service provider is not configured correctly.");
        }
        return (T)retVal;
    }
}

