/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.nhind.config.rest.TrustBundleService;
import org.nhind.config.rest.impl.requests.AddTrustBundleRequest;
import org.nhind.config.rest.impl.requests.AssociateTrustBundleToDomainRequest;
import org.nhind.config.rest.impl.requests.DeleteTrustBundleRequest;
import org.nhind.config.rest.impl.requests.DisassociateTrustBundleFromDomainRequest;
import org.nhind.config.rest.impl.requests.DisassociateTrustBundleFromDomainsRequest;
import org.nhind.config.rest.impl.requests.DisassociateTrustBundlesFromDomainRequest;
import org.nhind.config.rest.impl.requests.GetTrustBundleRequest;
import org.nhind.config.rest.impl.requests.GetTrustBundlesByDomainRequest;
import org.nhind.config.rest.impl.requests.GetTrustBundlesRequest;
import org.nhind.config.rest.impl.requests.RefreshTrustBundleRequest;
import org.nhind.config.rest.impl.requests.UpdateSigningCertRequest;
import org.nhind.config.rest.impl.requests.UpdateTrustBundleAttributesRequest;
import org.nhindirect.common.rest.AbstractSecuredService;
import org.nhindirect.common.rest.ServiceRequest;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleDomainReltn;

public class DefaultTrustBundleService
extends AbstractSecuredService
implements TrustBundleService {
    public DefaultTrustBundleService(String serviceUrl, HttpClient httpClient, ServiceSecurityManager securityManager) {
        super(serviceUrl, httpClient, securityManager);
    }

    @Override
    public Collection<TrustBundle> getTrustBundles(boolean fetchAnchors) throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetTrustBundlesRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, fetchAnchors));
    }

    @Override
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(String domainName, boolean fetchAnchors) throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetTrustBundlesByDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, domainName, fetchAnchors));
    }

    @Override
    public TrustBundle getTrustBundle(String bundleName) throws ServiceException {
        Collection bundles = (Collection)this.callWithRetry((ServiceRequest)new GetTrustBundleRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName));
        return bundles.isEmpty() ? null : (TrustBundle)bundles.iterator().next();
    }

    @Override
    public void addTrustBundle(TrustBundle bundle) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AddTrustBundleRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundle));
    }

    @Override
    public void refreshTrustBundle(String bundleName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new RefreshTrustBundleRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName));
    }

    @Override
    public void deleteTrustBundle(String bundleName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DeleteTrustBundleRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName));
    }

    @Override
    public void updateSigningCert(String bundleName, X509Certificate cert) throws ServiceException {
        this.callWithRetry((ServiceRequest)new UpdateSigningCertRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName, cert));
    }

    @Override
    public void updateTrustBundleAttributes(String bundleName, TrustBundle bundleData) throws ServiceException {
        this.callWithRetry((ServiceRequest)new UpdateTrustBundleAttributesRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName, bundleData));
    }

    @Override
    public void associateTrustBundleToDomain(String bundleName, String domainName, boolean incoming, boolean outgoing) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AssociateTrustBundleToDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName, domainName, incoming, outgoing));
    }

    @Override
    public void disassociateTrustBundleFromDomain(String bundleName, String domainName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociateTrustBundleFromDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName, domainName));
    }

    @Override
    public void disassociateTrustBundlesFromDomain(String domainName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociateTrustBundlesFromDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, domainName));
    }

    @Override
    public void disassociateTrustBundleFromDomains(String bundleName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociateTrustBundleFromDomainsRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, bundleName));
    }
}

