/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.provider;

import com.google.inject.Provider;
import java.io.File;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.impl.FileAuditor;

public class FileAuditorProvider
implements Provider<Auditor> {
    private final File auditFile;

    public FileAuditorProvider(String fileLoc) {
        if (fileLoc == null || fileLoc.isEmpty()) {
            throw new IllegalArgumentException("File location cannot be null or empty");
        }
        this.auditFile = new File(fileLoc);
    }

    public FileAuditorProvider(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.auditFile = file;
    }

    public Auditor get() {
        return new FileAuditor(this.auditFile);
    }
}

