/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.impl;

import java.security.Key;
import java.security.KeyStore;
import javax.crypto.spec.SecretKeySpec;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.common.crypto.impl.StaticPKCS11TokenKeyStoreProtectionManager;

public class StaticCachedPKCS11TokenKeyStoreProtectionManager
extends StaticPKCS11TokenKeyStoreProtectionManager {
    private Key keystoreProtectionKey;
    private Key privateKeyProtectionKey;

    public StaticCachedPKCS11TokenKeyStoreProtectionManager() throws CryptoException {
    }

    public StaticCachedPKCS11TokenKeyStoreProtectionManager(PKCS11Credential credential, String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias) throws CryptoException {
        super(credential, keyStorePassPhraseAlias, privateKeyPassPhraseAlias);
    }

    @Override
    public void initTokenStore() throws CryptoException {
        this.loadProvider();
        try {
            this.ks = KeyStore.getInstance(this.keyStoreType);
            this.ks.load(this.keyStoreSource, this.credential.getPIN());
            this.keystoreProtectionKey = this.getKey(this.keyStorePassPhraseAlias);
            this.privateKeyProtectionKey = this.getKey(this.privateKeyPassPhraseAlias);
            this.keystoreProtectionKey = new SecretKeySpec(this.keystoreProtectionKey.getEncoded(), "");
            this.privateKeyProtectionKey = new SecretKeySpec(this.privateKeyProtectionKey.getEncoded(), "");
        }
        catch (Exception e) {
            throw new CryptoException("Error initializing PKCS11 token", e);
        }
    }

    @Override
    public Key getPrivateKeyProtectionKey() throws CryptoException {
        return this.privateKeyProtectionKey;
    }

    @Override
    public Key getKeyStoreProtectionKey() throws CryptoException {
        return this.keystoreProtectionKey;
    }
}

