/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.common.crypto.impl.DynamicPKCS11TokenKeyStoreProtectionManager;
import org.nhindirect.common.crypto.tools.TokenLoginCallback;

public class PKCS11SecretKeyManagerUI
extends JFrame {
    private static final long serialVersionUID = 4851276510546674236L;
    protected static String pkcs11ProviderCfg = null;
    protected static String keyStoreConfigFile = null;
    protected static MutableKeyStoreProtectionManager mgr = null;
    private static String keyStoreType = null;
    private static String providerName = null;
    private static String keyStoreSource = null;
    protected JTable keyDataTable;
    protected JButton removeKeyButton;
    protected JButton addAESKeyButton;
    protected JButton addGenericKeyButton;
    protected JButton addCertificate;
    protected DefaultTableModel keyDataModel;
    protected JButton quitButton;

    public static void main(String[] argv) {
        if (argv.length > 0) {
            for (int i = 0; i < argv.length; ++i) {
                String arg = argv[i];
                if (!arg.startsWith("-")) {
                    System.err.println("Error: Unexpected argument [" + arg + "]\n");
                    PKCS11SecretKeyManagerUI.printUsage();
                    System.exit(-1);
                    continue;
                }
                if (arg.equalsIgnoreCase("-pkcscfg")) {
                    if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                        System.err.println("Error: Missing pkcs config file");
                        System.exit(-1);
                    }
                    pkcs11ProviderCfg = argv[++i];
                    continue;
                }
                if (arg.equals("-keyStoreCfg")) {
                    if (i == argv.length - 1 || argv[i + 1].startsWith("-")) {
                        System.err.println("Error: Missing keystore config file");
                        System.exit(-1);
                    }
                    keyStoreConfigFile = argv[++i];
                    continue;
                }
                if (arg.equals("-help")) {
                    PKCS11SecretKeyManagerUI.printUsage();
                    System.exit(-1);
                    continue;
                }
                System.err.println("Error: Unknown argument " + arg + "\n");
                PKCS11SecretKeyManagerUI.printUsage();
                System.exit(-1);
            }
        }
        if (keyStoreConfigFile != null) {
            try {
                FileInputStream inStream = FileUtils.openInputStream((File)new File(keyStoreConfigFile));
                Properties props = new Properties();
                props.load(inStream);
                keyStoreType = props.getProperty("keyStoreType");
                providerName = props.getProperty("keyStoreProviderName");
                keyStoreSource = props.getProperty("keyStoreSource");
            }
            catch (IOException e) {
                System.err.println("Error reading keystore config file to properties: " + e.getMessage());
                System.exit(-1);
            }
        }
        try {
            mgr = PKCS11SecretKeyManagerUI.tokenLogin();
        }
        catch (CryptoException e) {
            JOptionPane.showMessageDialog(null, "Failed to login to hardware token: " + e.getMessage(), "Token Login Failure", 0);
            System.exit(-1);
        }
        PKCS11SecretKeyManagerUI hi = new PKCS11SecretKeyManagerUI();
        hi.setVisible(true);
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java PKCS11SecretKeyManagerUI (options)...\n\n");
        use.append("options:\n");
        use.append("-pkcscfg    PKCS11 Config File  Optional location for the PKCS11 provider configuration.  If this is not set, then it is assumed that the JVM has already been configured to support your PKCS11 token.\n");
        use.append("            Default: \"\"\n\n");
        System.err.println(use);
    }

    public static MutableKeyStoreProtectionManager tokenLogin() throws CryptoException {
        TokenLoginCallback login = new TokenLoginCallback();
        DynamicPKCS11TokenKeyStoreProtectionManager loginMgr = new DynamicPKCS11TokenKeyStoreProtectionManager();
        loginMgr.setKeyStoreProviderName(providerName);
        if (!StringUtils.isEmpty((String)keyStoreType)) {
            loginMgr.setKeyStoreType(keyStoreType);
        }
        if (!StringUtils.isEmpty((String)keyStoreSource)) {
            ByteArrayInputStream str = new ByteArrayInputStream(keyStoreSource.getBytes());
            loginMgr.setKeyStoreSource(str);
        }
        if (!StringUtils.isEmpty((String)pkcs11ProviderCfg)) {
            loginMgr.setPcks11ConfigFile(pkcs11ProviderCfg);
        }
        loginMgr.setCallbackHandler(login);
        loginMgr.initTokenStore();
        return loginMgr;
    }

    public PKCS11SecretKeyManagerUI() {
        super("DirectProject PKCS11 Secret Key Manager");
        PKCS11SecretKeyManagerUI.setDefaultLookAndFeelDecorated(true);
        this.setSize(700, 700);
        Point pt = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(pt.x - 350, pt.y - 350);
        this.enableEvents(64L);
        this.setDefaultCloseOperation(3);
        this.initUI();
        this.addActions();
        this.updateKeyTableData();
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        this.addAESKeyButton = new JButton("Add AES Key");
        this.addAESKeyButton.setSize(new Dimension(30, 100));
        this.addGenericKeyButton = new JButton("Add Text Key");
        this.addGenericKeyButton.setSize(new Dimension(30, 100));
        this.removeKeyButton = new JButton("Remove Key(s)");
        this.removeKeyButton.setSize(new Dimension(30, 100));
        topPanel.add(this.addAESKeyButton);
        topPanel.add(this.addGenericKeyButton);
        topPanel.add(this.removeKeyButton);
        this.getContentPane().add((Component)topPanel, "North");
        JPanel midPanel = new JPanel();
        midPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        midPanel.setLayout(new BorderLayout(5, 5));
        JLabel keyListLabel = new JLabel("Secret Keys:");
        Object[][] data = new Object[][]{};
        Object[] columnNames = new String[]{"Key Alias", "Key Type", "Key Value"};
        this.keyDataModel = new DefaultTableModel(data, columnNames);
        this.keyDataTable = new JTable(this.keyDataModel);
        JScrollPane scrollPane = new JScrollPane(this.keyDataTable);
        this.keyDataTable.setFillsViewportHeight(true);
        midPanel.add((Component)keyListLabel, "North");
        midPanel.add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)midPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.quitButton = new JButton("Quit");
        this.quitButton.setSize(new Dimension(30, 100));
        bottomPanel.add(this.quitButton);
        this.getContentPane().add((Component)bottomPanel, "South");
    }

    private void addActions() {
        this.addAESKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11SecretKeyManagerUI.this.addAESKey();
            }
        });
        this.addGenericKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11SecretKeyManagerUI.this.addTextKey();
            }
        });
        this.removeKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11SecretKeyManagerUI.this.removeKeys();
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(-1);
            }
        });
    }

    private void addAESKey() {
        String input = JOptionPane.showInputDialog(this, "Key Alias Name:", "Generate New random AES Secret Key", 2);
        if (input != null && !input.trim().isEmpty()) {
            try {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                SecureRandom random = new SecureRandom();
                keyGen.init(random);
                SecretKey key = keyGen.generateKey();
                mgr.clearKey(input);
                mgr.setKey(input, key);
                this.updateKeyTableData();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to add random new AES key: " + e.getMessage(), "Add Key Error", 0);
            }
        }
    }

    private void addTextKey() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JLabel aliasLabel = new JLabel("Alias:");
        aliasLabel.setSize(60, 30);
        JTextField aliasField = new JTextField(40);
        topPanel.add(aliasLabel);
        topPanel.add(aliasField);
        JPanel bottomPanel = new JPanel();
        JLabel keyLabel = new JLabel("Key:");
        keyLabel.setSize(60, 30);
        JTextField keyField = new JTextField(40);
        bottomPanel.add(keyLabel);
        bottomPanel.add(keyField);
        panel.add((Component)topPanel, "North");
        panel.add((Component)bottomPanel, "South");
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(null, panel, "Generate New Text Based Secret Key ", 2, -1, null, options, options[0]);
        if (option == 0) {
            String alias = aliasField.getText();
            String keyText = keyField.getText();
            if (alias != null && !alias.trim().isEmpty() && keyText != null && !keyText.trim().isEmpty()) {
                try {
                    byte[] key = keyText.getBytes("UTF-8");
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    key = sha.digest(key);
                    key = Arrays.copyOf(key, 16);
                    mgr.clearKey(alias);
                    mgr.setKey(alias, new SecretKeySpec(key, "AES"));
                    this.updateKeyTableData();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to add new text based secret key: " + e.getMessage(), "Add Key Error", 0);
                }
            }
        }
    }

    private void removeKeys() {
        if (this.keyDataTable.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No keys are selected.", "Remove Keys", 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to removed the selected Keys?", "Remove Keys", 0) == 0) {
            int[] rows;
            for (int row : rows = this.keyDataTable.getSelectedRows()) {
                String alias = (String)this.keyDataTable.getValueAt(row, 0);
                try {
                    mgr.clearKey(alias);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to remove key with alias " + alias + ":" + e.getMessage(), "Remove Key Error", 0);
                }
            }
            this.updateKeyTableData();
        }
    }

    private void updateKeyTableData() {
        try {
            for (int ctx = this.keyDataModel.getRowCount() - 1; ctx >= 0; --ctx) {
                this.keyDataModel.removeRow(ctx);
            }
            Map<String, Key> keys = mgr.getAllKeys();
            for (Map.Entry<String, Key> entry : keys.entrySet()) {
                String type = "";
                Key value = entry.getValue();
                type = value instanceof SecretKey ? "Secret Key: " + value.getAlgorithm() : (value instanceof PublicKey ? "Public Key: " + value.getAlgorithm() : (value instanceof PrivateKey ? "Private Key: " + value.getAlgorithm() : value.getClass().toString()));
                this.keyDataModel.addRow(new Object[]{entry.getKey(), type, "***"});
                this.keyDataModel.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

